<?php
session_start();
header('Content-Type: application/json');
require_once('../includes/connection.php');

$course_id = isset($_POST['course_id']) ? intval($_POST['course_id']) : 0;
$user_id = isset($_SESSION['user_id']) ? $_SESSION['user_id'] : null;
$user_category = isset($_SESSION['category']) ? $_SESSION['category'] : null;

if (!$course_id) {
    echo json_encode(['success' => false, 'message' => 'Course ID missing']);
    exit;
}

try {
    // Check if course exists, is already published, and is approved
    $checkStmt = $pdo->prepare("SELECT is_publish, expert_approval_status, created_by FROM course_master WHERE course_id = :id");
    $checkStmt->bindParam(':id', $course_id, PDO::PARAM_INT);
    $checkStmt->execute();
    $course = $checkStmt->fetch(PDO::FETCH_ASSOC);

    if (!$course) {
        echo json_encode(['success' => false, 'message' => 'Course not found.']);
        exit;
    }

    // If user is mentor, check if they created this course
    if ($user_category === 'mentor' && $user_id) {
        if ($course['created_by'] != $user_id) {
            echo json_encode(['success' => false, 'message' => 'You can only publish courses that you created.']);
            exit;
        }
    }

    if ($course['is_publish'] == 1) {
        echo json_encode(['success' => false, 'message' => 'Course is already published.']);
        exit;
    }

    // Check if course is approved before allowing publish
    if ($course['expert_approval_status'] !== 'approved') {
        echo json_encode(['success' => false, 'message' => 'Course must be approved by industry expert before publishing.']);
        exit;
    }

    // Update to publish
    $stmt = $pdo->prepare("
        UPDATE course_master
        SET is_publish = 1
        WHERE course_id = :id
    ");
    $stmt->bindParam(':id', $course_id, PDO::PARAM_INT);
    $stmt->execute();

    if ($stmt->rowCount() > 0) {
        echo json_encode(['success' => true, 'message' => 'Course published successfully.']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Failed to publish the course.']);
    }
} catch (PDOException $e) {
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>
