<?php
header('Content-Type: application/json');
require_once('../includes/connection.php');

$course_id = isset($_POST['course_id']) ? intval($_POST['course_id']) : 0;

if (!$course_id) {
    echo json_encode(['success' => false, 'message' => 'Course ID missing']);
    exit;
}

try {
    // Check if course exists and is already published
    $checkStmt = $pdo->prepare("SELECT is_publish FROM course_master WHERE course_id = :id");
    $checkStmt->bindParam(':id', $course_id, PDO::PARAM_INT);
    $checkStmt->execute();
    $course = $checkStmt->fetch(PDO::FETCH_ASSOC);

    if (!$course) {
        echo json_encode(['success' => false, 'message' => 'Course not found.']);
        exit;
    }

    if ($course['is_publish'] == 1) {
        echo json_encode(['success' => false, 'message' => 'Course is already published.']);
        exit;
    }

    // Update to publish
    $stmt = $pdo->prepare("
        UPDATE course_master
        SET is_publish = 1
        WHERE course_id = :id
    ");
    $stmt->bindParam(':id', $course_id, PDO::PARAM_INT);
    $stmt->execute();

    if ($stmt->rowCount() > 0) {
        echo json_encode(['success' => true, 'message' => 'Course published successfully.']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Failed to publish the course.']);
    }
} catch (PDOException $e) {
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>
