<?php
header('Content-Type: application/json');
require_once('../includes/connection.php');

try {
    $draw = $_POST['draw'] ?? 1;
    $start = (int)($_POST['start'] ?? 0);
    $length = (int)($_POST['length'] ?? 10);
    $searchValue = $_POST['search']['value'] ?? '';
    $sortField = $_POST['sortField'] ?? 'qm.question_master_id';
    $sortDir = strtoupper($_POST['sortDir'] ?? 'DESC');
    $category_id = $_POST['category_id'] ?? '';
    $criteria = $_POST['criteria'] ?? '';

    if (!in_array($sortDir, ['ASC', 'DESC'])) {
        $sortDir = 'DESC';
    }
    
    $allowedSortFields = ['qm.question_master_id', 'qm.question', 'cm.category_name', 'qm.criteria', 'qm.media'];
    if (!in_array($sortField, $allowedSortFields)) {
        $sortField = 'qm.question_master_id';
    }

    $searchQuery = "WHERE qm.is_deleted != 1";
    $searchParams = [];

    if (!empty($category_id)) {
        $searchQuery .= " AND qm.category_course_id = ?";
        $searchParams[] = $category_id;
    }
    
    if (!empty($criteria)) {
        $searchQuery .= " AND qm.criteria = ?";
        $searchParams[] = $criteria;
    }
    
    if (!empty($searchValue)) {
        $searchValue = trim($searchValue);
        
        // Normalize various quote types to standard quotes
        $normalized = str_replace(["\xE2\x80\x9C", "\xE2\x80\x9D"], '"', $searchValue); // Curly double quotes
        $normalized = str_replace(["\xE2\x80\x98", "\xE2\x80\x99"], "'", $normalized); // Curly single quotes
        $normalized = str_replace(["\xE2\x80\x9A", "\xE2\x80\x9B"], "'", $normalized); // Single low-9 and high-reversed-9 quotes
        $normalized = str_replace(["\xE2\x80\x9E", "\xE2\x80\x9F"], '"', $normalized); // Double low-9 quotes
        
        // Escape special LIKE wildcards (% and _) - but keep quotes for now
        $escaped = str_replace(['%', '_'], ['\%', '\_'], $normalized);
        
        // Create multiple search patterns to handle different quote styles in database
        $likeOriginal = "%" . strtolower($escaped) . "%";
        $likeNoQuotes = "%" . strtolower(str_replace(['"', "'"], '', $escaped)) . "%"; // Remove all quotes
        $likeSingleQuotes = "%" . strtolower(str_replace('"', '', $escaped)) . "%"; // Keep single quotes, remove double
        $likeDoubleQuotes = "%" . strtolower(str_replace("'", '', $escaped)) . "%"; // Keep double quotes, remove single
        
        // Use LOWER() for case-insensitive search
        // Try multiple patterns for question field to handle different quote styles in DB
        $searchQuery .= " AND (
            (LOWER(qm.question) LIKE ? OR 
             LOWER(qm.question) LIKE ? OR 
             LOWER(qm.question) LIKE ? OR 
             LOWER(qm.question) LIKE ?) OR 
            LOWER(cm.category_name) LIKE ? OR 
            LOWER(qm.criteria) LIKE ? OR 
            LOWER(qm.media) LIKE ?
        ";
        $searchParams = array_merge($searchParams, [
            $likeOriginal,      // Original with all quotes
            $likeNoQuotes,      // Without any quotes
            $likeSingleQuotes,  // With single quotes only
            $likeDoubleQuotes,  // With double quotes only
            $likeOriginal,      // For category
            $likeOriginal,      // For criteria
            $likeOriginal       // For media
        ]);

        if (stripos($searchValue, 'inactive') !== false) {
            $searchQuery .= " OR qm.is_block = ?";
            $searchParams[] = '1';
        } elseif (stripos($searchValue, 'active') !== false) {
            $searchQuery .= " OR qm.is_block = ?";
            $searchParams[] = '0';
        }

        $searchQuery .= ")";
    }

    $totalRecords = $pdo->query("SELECT COUNT(*) FROM question_master WHERE is_deleted != 1")->fetchColumn();

    if (!empty($searchParams)) {
        $filteredStmt = $pdo->prepare("
            SELECT COUNT(*) 
            FROM question_master qm
            LEFT JOIN category_master cm ON qm.category_course_id = cm.category_id
            $searchQuery
        ");
        $filteredStmt->execute($searchParams);
        $filteredRecords = $filteredStmt->fetchColumn();
    } else {
        $filteredRecords = $totalRecords;
    }

    $dataSql = "
        SELECT 
            qm.question_master_id, 
            qm.question,
            qm.criteria,
            cm.category_name,
            qm.media,
            qm.marks,
            qm.duration
        FROM question_master qm
        LEFT JOIN category_master cm ON qm.category_course_id = cm.category_id
        $searchQuery
        ORDER BY $sortField $sortDir
        LIMIT ?, ?
    ";
    $dataStmt = $pdo->prepare($dataSql);
    $dataStmt->execute(array_merge($searchParams, [$start, $length]));
    $data = $dataStmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode([
        'draw' => intval($draw),
        'recordsTotal' => intval($totalRecords),
        'recordsFiltered' => intval($filteredRecords),
        'data' => $data
    ]);

} catch (Exception $e) {
    echo json_encode([
        'draw' => intval($_POST['draw'] ?? 1),
        'recordsTotal' => 0,
        'recordsFiltered' => 0,
        'data' => [],
        'error' => true,
        'message' => $e->getMessage()
    ]);
}
