<?php
header('Content-Type: application/json');
require_once('../includes/connection.php');

try {
    $draw = $_POST['draw'] ?? 1;
    $start = (int)($_POST['start'] ?? 0);
    $length = (int)($_POST['length'] ?? 10);
    $searchValue = $_POST['search']['value'] ?? '';
    $sortField = $_POST['sortField'] ?? 'qm.question_master_id';
    $sortDir = strtoupper($_POST['sortDir'] ?? 'DESC');
    $category_id = $_POST['category_id'] ?? '';
    $criteria = $_POST['criteria'] ?? ''; 


    // Validate sort direction
    if (!in_array($sortDir, ['ASC', 'DESC'])) {
        $sortDir = 'DESC';
    }

    // Allowed sort fields
    $allowedSortFields = ['qm.question_master_id', 'qm.question', 'cm.category_name', 'qm.criteria', 'qm.media'];
    if (!in_array($sortField, $allowedSortFields)) {
        $sortField = 'qm.question_master_id';
    }

    // Base conditions
    $searchQuery = "WHERE qm.is_deleted != 1";
    $searchParams = [];

    // Filter by category
    if (!empty($category_id)) {
        $searchQuery .= " AND qm.category_course_id = ?";
        $searchParams[] = $category_id;
    }
    
    // Filter by criteria (only if passed)
    if (!empty($criteria)) {
        $searchQuery .= " AND qm.criteria = ?";
        $searchParams[] = $criteria;
    }    

    // Filter by search value
    if (!empty($searchValue)) {
        $like = "%$searchValue%";
        $searchQuery .= " AND (qm.question LIKE ? OR cm.category_name LIKE ? OR qm.criteria LIKE ? OR qm.media LIKE ?";
        $searchParams = array_merge($searchParams, [$like, $like, $like, $like]);

        if (stripos($searchValue, 'inactive') !== false) {
            $searchQuery .= " OR qm.is_block = ?";
            $searchParams[] = '1';
        } elseif (stripos($searchValue, 'active') !== false) {
            $searchQuery .= " OR qm.is_block = ?";
            $searchParams[] = '0';
        }

        $searchQuery .= ")";
    }

    // Total records count
    $totalRecords = $pdo->query("SELECT COUNT(*) FROM question_master WHERE is_deleted != 1")->fetchColumn();

    // Filtered records count
    if (!empty($searchParams)) {
        $filteredStmt = $pdo->prepare("
            SELECT COUNT(*) 
            FROM question_master qm
            LEFT JOIN category_master cm ON qm.category_course_id = cm.category_id
            $searchQuery
        ");
        $filteredStmt->execute($searchParams);
        $filteredRecords = $filteredStmt->fetchColumn();
    } else {
        $filteredRecords = $totalRecords;
    }

    // Fetch paginated data
    $dataSql = "
        SELECT 
            qm.question_master_id, 
            qm.question,
            qm.criteria,
            cm.category_name,
            qm.media,
            qm.marks,
            qm.duration
        FROM question_master qm
        LEFT JOIN category_master cm ON qm.category_course_id = cm.category_id
        $searchQuery
        ORDER BY $sortField $sortDir
        LIMIT ?, ?
    ";
    $dataStmt = $pdo->prepare($dataSql);
    $finalParams = array_merge($searchParams, [$start, $length]);
    $dataStmt->execute($finalParams);
    $data = $dataStmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode([
        'draw' => intval($draw),
        'recordsTotal' => intval($totalRecords),
        'recordsFiltered' => intval($filteredRecords),
        'data' => $data
    ]);

} catch (Exception $e) {
    echo json_encode([
        'error' => true,
        'message' => $e->getMessage()
    ]);
}