<?php
require_once('../includes/connection.php');
require('../vendor/autoload.php');

use Vimeo\Vimeo;

function uploadStudyMaterial($file, $title, $course_category)
{
    $clientId = "33aca9a43d56881867d184a6fd6812214c859d7f";
    $clientSecret = "RxhsebeBUpDtexh1NEy/wtvc6nygztKCQuLdumBH9brJxhYccpNdUDs2dbrBJgi8ERWF+5ey2jShRKRt5+zboo9Euza+5XIkgfnKhBSPEk0o9dT4W8FEZmUuKEl6td4b";
    $accessToken = "75e5b3cf9fecae07f07f254889398e20";

    $projectId = '27758751'; // question_videos folder
    $userId = '239261674'; // Your Vimeo user ID

    global $pdo;

    if ($file['error'] === UPLOAD_ERR_OK) {
        $fileTmp = $file['tmp_name'];
        $fileName = $file['name'];
        $fileType = mime_content_type($fileTmp);

        $allowedVideoTypes = ['video/mp4', 'video/avi', 'video/mov', 'video/mkv'];
        $allowedDocTypes = ['application/pdf', 'image/jpeg', 'image/png'];

        if (in_array($fileType, $allowedVideoTypes)) {
            $client = new Vimeo($clientId, $clientSecret, $accessToken);

            try {
                // Upload video
                $uri = $client->upload($fileTmp, [
                    "name" => $title,
                ]);

                // Check transcoding status
                $transcode = $client->request($uri . '?fields=transcode.status');
                $status = $transcode['body']['transcode']['status'];

                if ($status === 'complete') {
                    $statusMsg = 'Your video finished transcoding.';
                } elseif ($status === 'in_progress') {
                    $statusMsg = 'Video uploaded successfully.';
                } else {
                    throw new Exception('Video transcoding failed.');
                }

                // Extract video ID
                $videoId = str_replace('/videos/', '', $uri);

                // Move video to folder
                $moveResponse = $client->request(
                    "/users/{$userId}/projects/{$projectId}/videos/{$videoId}",
                    [],
                    'PUT'
                );

                if ($moveResponse['status'] !== 204) {
                    throw new Exception("Failed to move video to folder. Vimeo responded with status " . $moveResponse['status']);
                }

                // Get video link
                $videoInfo = $client->request($uri . '?fields=link');
                $videoLink = $videoInfo['body']['link'];
                $get_vid_id = explode("/", $videoLink)[3];

                // You can optionally insert into DB here...

return [
    'success' => true,
    'message' => $statusMsg,
    'video_link' => $videoLink,
    'video_id' => $get_vid_id
];

            } catch (Exception $e) {
                echo json_encode(['success' => false, 'message' => 'Vimeo Upload Error: ' . $e->getMessage()]);
                return;
            }

        } elseif (in_array($fileType, $allowedDocTypes)) {
            $uploadDir = '../study/';
            if (!file_exists($uploadDir)) {
                mkdir($uploadDir, 0755, true);
            }

            $newFilePath = $uploadDir . basename($fileName);
            if (move_uploaded_file($fileTmp, $newFilePath)) {
                echo json_encode(['success' => true, 'message' => 'File uploaded successfully.']);
            } else {
                echo json_encode(['success' => false, 'message' => 'Failed to move file to folder.']);
            }

        } else {
            echo json_encode(['success' => false, 'message' => 'Unsupported file type.']);
        }

    } else {
        echo json_encode(['success' => false, 'message' => 'Error with the uploaded file.']);
    }
}