<?php
session_start();
header('Content-Type: application/json');
require_once('../includes/connection.php');

$data = json_decode(file_get_contents("php://input"), true);
$new_password = base64_encode(trim($data['new_password']));
$token = trim($data['token']);

if (empty($token)) {
    echo json_encode(['status' => false, 'message' => 'Invalid or missing token.']);
    exit;
}

try {
    // Verify token and check expiration
    $stmt = $pdo->prepare("SELECT email FROM password_reset WHERE token = :token AND expires_at > NOW()");
    $stmt->execute(['token' => $token]);
    $resetRow = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($resetRow) {
        $email = $resetRow['email'];

        // Directly store the decoded password (base64-decoded)
        $updateStmt = $pdo->prepare("UPDATE user_master SET password = :password WHERE email_id = :email");
        $updateStmt->execute([
            'password' => $new_password,
            'email' => $email
        ]);

        // Remove token after successful update
        $deleteStmt = $pdo->prepare("DELETE FROM password_reset WHERE email = :email");
        $deleteStmt->execute(['email' => $email]);

        echo json_encode(['status' => true, 'message' => 'Password has been successfully reset']);
    } else {
        echo json_encode(['status' => false, 'message' => 'Invalid link or expired token']);
    }

} catch (Exception $e) {
    echo json_encode(['status' => false, 'message' => 'Server Error: ' . $e->getMessage()]);
}
?>
