<?php
session_start();
header('Content-Type: application/json');

require_once('../includes/connection.php');
if (!isset($_SESSION['user_id'])) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Session expired. Please login again.'
    ]);
    exit;
}

$email_title   = trim($_POST['email_title'] ?? '');
$course_id     = $_POST['course_id'] ?? null;
$institute_id  = $_POST['institute_id'] ?? null;
$subject       = trim($_POST['subject'] ?? '');
$email_content = trim($_POST['email_content'] ?? '');

if ($email_title === '' || $subject === '' || $email_content === '' || !$institute_id) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Required fields missing'
    ]);
    exit;
}

try {

    $notificationStmt = $pdo->prepare("
        INSERT INTO student_notifications
        (email_title, course_id, institute_id, subject, email_content)
        VALUES
        (:email_title, :course_id, :institute_id, :subject, :email_content)
    ");

    $notificationStmt->execute([
        ':email_title'   => $email_title,
        ':course_id'     => $course_id,
        ':institute_id'  => $institute_id,
        ':subject'       => $subject,
        ':email_content' => $email_content
    ]);

    $notification_id = $pdo->lastInsertId();

    $studentStmt = $pdo->prepare("
        SELECT email_id
        FROM student_master
        WHERE institute_id = :institute_id
          AND is_block != 1
          AND is_deleted != 1
          AND email_id != ''
    ");

    $studentStmt->execute([
        ':institute_id' => $institute_id
    ]);

    $students = $studentStmt->fetchAll(PDO::FETCH_ASSOC);

    if (!$students) {
        throw new Exception('No students found');
    }

    $queueStmt = $pdo->prepare("
        INSERT INTO student_notifications_email
        (notification_id, student_email)
        VALUES
        (:notification_id, :student_email)
    ");

    $inserted = 0;

    foreach ($students as $student) {
        $queueStmt->execute([
            ':notification_id' => $notification_id,
            ':student_email'   => $student['email_id']
        ]);
        $inserted++;
    }

    echo json_encode([
        'status' => 'success',
        'message' => 'Bulk notification saved successfully',
        'notification_id' => $notification_id,
        'total_recipients' => $inserted
    ]);

} catch (Exception $e) {

    $pdo->rollBack();

    echo json_encode([
        'status' => 'error',
        'message' => $e->getMessage()
    ]);
}