<?php
require_once('../includes/connection.php');
header('Content-Type: application/json');
session_start();

if (isset($_POST['draft_id']) && isset($_POST['course_title']) && isset($_POST['category'])) {
    $draftId = $_POST['draft_id'];
    $courseTitle = trim($_POST['course_title']);
    $courseCategory = $_POST['category'];
    $courseDescription = $_POST['course_description'] ?? '';
    $mentorIds = isset($_POST['mentor']) ? implode(',', $_POST['mentor']) : '';
    $industryExpertIds = isset($_POST['industry_expert_ids']) ? $_POST['industry_expert_ids'] : '';
    $level = $_POST['level'] ?? 0;
    $startDate = $_POST['schedule_from'] ?? '';
    $endDate = $_POST['schedule_to'] ?? '';
    $testimonials = isset($_POST['testimonial']) ? implode(',', $_POST['testimonial']) : '';
    $proposedCourses = isset($_POST['proposed_course']) ? implode(',', $_POST['proposed_course']) : '';
    $language = $_POST['language'] ?? '';
    $noOfLicenses = $_POST['no_of_license'] ?? 0;
    $courseFees = $_POST['course_fees'] ?? 0;
    $faqIds = $_POST['faq_ids'] ?? '';

    // File upload
    $courseImage = '';
    if (isset($_FILES['course_img']) && $_FILES['course_img']['error'] == UPLOAD_ERR_OK) {
        $file = $_FILES['course_img'];
        $allowedTypes = ['image/jpeg', 'image/png', 'image/webp'];
        if (!in_array($file['type'], $allowedTypes)) {
            echo json_encode(["success" => false, "message" => "Invalid image type."]);
            exit;
        }
        $encryptedName = bin2hex(random_bytes(16)) . '.' . pathinfo($file['name'], PATHINFO_EXTENSION);
        $uploadPath = '../images/course_image/' . $encryptedName;

        if (move_uploaded_file($file['tmp_name'], $uploadPath)) {
            $courseImage = $encryptedName;
        } else {
            echo json_encode(["success" => false, "message" => "Failed to upload course image."]);
            exit;
        }
    }

    try {
        $user_id = $_SESSION['user_id'];
        $institute_id = $_SESSION['institute_id'];

        $updateQuery = "UPDATE course_draft SET 
            institute_id = :institute_id,
            course_title = :course_title,
            course_description = :course_description,
            course_category = :course_category,
            mentor_ids = :mentor_ids,
            industry_expert_ids = :industry_expert_ids,
            level = :level,
            start_date = :start_date,
            end_date = :end_date,
            testimonials = :testimonials,
            proposed_courses = :proposed_courses,
            language = :language,
            no_of_licenses = :no_of_licenses,
            course_fees = :course_fees,
            faq_ids = :faq_ids,
            created_by = :user_id";

        if (!empty($courseImage)) {
            $updateQuery .= ", course_img = :course_img";
        }

        $updateQuery .= " WHERE draft_id = :draft_id";

        $stmt = $pdo->prepare($updateQuery);
        $stmt->bindParam(':institute_id', $institute_id);
        $stmt->bindParam(':course_title', $courseTitle);
        $stmt->bindParam(':course_description', $courseDescription);
        $stmt->bindParam(':course_category', $courseCategory);
        $stmt->bindParam(':mentor_ids', $mentorIds);
        $stmt->bindParam(':industry_expert_ids', $industryExpertIds);
        $stmt->bindParam(':level', $level);
        $stmt->bindParam(':start_date', $startDate);
        $stmt->bindParam(':end_date', $endDate);
        $stmt->bindParam(':testimonials', $testimonials);
        $stmt->bindParam(':proposed_courses', $proposedCourses);
        $stmt->bindParam(':language', $language);
        $stmt->bindParam(':no_of_licenses', $noOfLicenses);
        $stmt->bindParam(':course_fees', $courseFees);
        $stmt->bindParam(':faq_ids', $faqIds);
        $stmt->bindParam(':user_id', $user_id);
        if (!empty($courseImage)) {
            $stmt->bindParam(':course_img', $courseImage);
        }
        $stmt->bindParam(':draft_id', $draftId);

        $stmt->execute();

        echo json_encode(["success" => true, "message" => "Course draft updated successfully."]);
    } catch (Exception $e) {
        echo json_encode(["success" => false, "message" => "Error: " . $e->getMessage()]);
    }
} else {
    echo json_encode(["success" => false, "message" => "Missing required fields (draft_id, course_title, category)."]);
}

?>
