<?php
header('Content-Type: application/json');
require_once('../includes/connection.php');

try {

    $email_title   = trim($_POST['email_title'] ?? '');
    $subject       = trim($_POST['subject'] ?? '');
    $email_content = $_POST['email_content'] ?? '';

    if ($email_title === '' || $subject === '' || $email_content === '') {
        echo json_encode([
            'status' => 'error',
            'message' => 'All fields are required'
        ]);
        exit;
    }

    $checkStmt = $pdo->prepare(
        "SELECT 1 FROM notification_template WHERE email_title = ? LIMIT 1"
    );
    $checkStmt->execute([$email_title]);

    if ($checkStmt->fetch()) {
        echo json_encode([
            'status' => 'error',
            'message' => 'Email title already exists. Please use a different title.'
        ]);
        exit;
    }


    $stmt = $pdo->prepare("
        INSERT INTO notification_template
        (email_title, subject, email_content)
        VALUES (:email_title, :subject, :email_content)
    ");

    $stmt->execute([
        ':email_title'   => $email_title,
        ':subject'       => $subject,
        ':email_content' => $email_content
    ]);

    echo json_encode([
        'status' => 'success',
        'message' => 'Email template saved successfully'
    ]);

} catch (Exception $e) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Something went wrong while saving the template'
    ]);
}