<?php
header('Content-Type: application/json');
require_once('../includes/connection.php');

try {
    $draw   = $_POST['draw'] ?? 1;
    $start  = (int)($_POST['start'] ?? 0);
    $length = (int)($_POST['length'] ?? 10);

    $searchValue = $_POST['search']['value'] ?? '';

    $sortField = $_POST['sortField'] ?? 'submodule_id';
    $sortDir   = strtoupper($_POST['sortDir'] ?? 'DESC');

    if (!in_array($sortDir, ['ASC', 'DESC'])) {
        $sortDir = 'DESC';
    }

    $allowed = ['submodule_name', 'is_block', 'module_id', 'submodule_id'];
    if (!in_array($sortField, $allowed)) {
        $sortField = 'submodule_id';
    }

    // -----------------------
    // WHERE Clause
    // -----------------------
    $where  = " WHERE sm.is_deleted = 0 ";
    $params = [];

    if (!empty($searchValue)) {
        $like = "%{$searchValue}%";

        $where .= " AND (
                sm.submodule_name LIKE ?
                OR mm.module_name LIKE ?
            ";

        $params[] = $like;
        $params[] = $like;

        if (stripos($searchValue, 'inactive') !== false) {
            $where .= " OR sm.is_block = 1 ";
        } elseif (stripos($searchValue, 'active') !== false) {
            $where .= " OR sm.is_block = 0 ";
        }

        $where .= " ) ";
    }

    // -----------------------
    // Total Records
    // -----------------------
    $totalRecords = $pdo->query("
        SELECT COUNT(*) 
        FROM submodule_master 
        WHERE is_deleted = 0
    ")->fetchColumn();

    // -----------------------
    // Filtered Records
    // -----------------------
    $countSql = "
        SELECT COUNT(*)
        FROM submodule_master sm
        JOIN module_master mm ON sm.module_id = mm.module_id
        $where
    ";

    $countStmt = $pdo->prepare($countSql);
    $countStmt->execute($params);
    $filteredRecords = $countStmt->fetchColumn();

    // -----------------------
    // Fetch Records
    // -----------------------
    $dataSql = "
        SELECT
            sm.submodule_id,
            sm.submodule_name,
            sm.module_id,
            sm.is_block,
            mm.module_name
        FROM submodule_master sm
        JOIN module_master mm ON sm.module_id = mm.module_id
        $where
        ORDER BY sm.$sortField $sortDir
        LIMIT ?, ?
    ";

    $dataStmt = $pdo->prepare($dataSql);

    // Bind search params first
    $bindIndex = 1;
    foreach ($params as $p) {
        $dataStmt->bindValue($bindIndex++, $p);
    }

    // Bind LIMIT params (positional)
    $dataStmt->bindValue($bindIndex++, $start, PDO::PARAM_INT);
    $dataStmt->bindValue($bindIndex, $length, PDO::PARAM_INT);

    $dataStmt->execute();
    $data = $dataStmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode([
        "draw"            => intval($draw),
        "recordsTotal"    => intval($totalRecords),
        "recordsFiltered" => intval($filteredRecords),
        "data"            => $data
    ]);

} catch (Exception $e) {
    echo json_encode([
        "error"   => true,
        "message" => "Server Error: " . $e->getMessage()
    ]);
}
?>
