<?php
require_once ('../includes/connection.php');
$institute_id = $_SESSION['institute_id'];  // Session variable for institute_id

// Get the module_id from the GET request
$moduleId = isset($_GET['module_id']) ? $_GET['module_id'] : null;

// Check if module_id is provided
if ($moduleId) {
    try {
        // Query to fetch submodules based on module_id and multiple submodule_id
        $sql = "SELECT sm.submodule_id, sm.submodule_name
                FROM submodule_master sm
                JOIN module_master mm ON mm.module_id = sm.module_id
                WHERE sm.institute_id = :institute_id AND mm.module_id = :module_id AND sm.is_block != '1'
                ORDER BY sm.submodule_id ASC";

        // Prepare the SQL statement
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':institute_id', $institute_id, PDO::PARAM_INT);
        $stmt->bindParam(':module_id', $moduleId, PDO::PARAM_INT);
        $stmt->execute();

        // Fetch the results
        $submodules = $stmt->fetchAll(PDO::FETCH_ASSOC);

        // Return the result as JSON
        echo json_encode($submodules);
    } catch (PDOException $e) {
        // If an error occurs, return an error message
        echo json_encode(['error' => 'Database connection failed: ' . $e->getMessage()]);
    }
} else {
    // If no module_id is provided, return an error
    echo json_encode(['error' => 'Module ID is required']);
}
?>
