<?php
header('Content-Type: application/json');
require_once('../includes/connection.php');

try {
    $draw   = $_POST['draw'] ?? 1;
    $start  = (int)($_POST['start'] ?? 0);
    $length = (int)($_POST['length'] ?? 10);
    $searchValue = $_POST['search']['value'] ?? '';

    $sortField = $_POST['sortField'] ?? 'notification_template_id';
    $sortDir   = strtoupper($_POST['sortDir'] ?? 'DESC');

    // Validate sort direction
    if (!in_array($sortDir, ['ASC', 'DESC'])) {
        $sortDir = 'DESC';
    }

    // Allowed sort fields
    $allowedSortFields = ['notification_template_id', 'email_title'];
    if (!in_array($sortField, $allowedSortFields)) {
        $sortField = 'notification_template_id';
    }

    // Base WHERE clause
    $where = "WHERE 1=1";
    $params = [];

    // Search
    if (!empty($searchValue)) {
        $where .= " AND email_title LIKE ?";
        $params[] = "%$searchValue%";
    }

    // Total records
    $totalRecords = $pdo
        ->query("SELECT COUNT(*) FROM notification_template")
        ->fetchColumn();

    // Filtered records
    $countSql = "SELECT COUNT(*) FROM notification_template $where";
    $countStmt = $pdo->prepare($countSql);
    $countStmt->execute($params);
    $filteredRecords = $countStmt->fetchColumn();

    // Fetch data
    $dataSql = "
        SELECT notification_template_id, email_title
        FROM notification_template
        $where
        ORDER BY $sortField $sortDir
        LIMIT ?, ?
    ";
    $dataStmt = $pdo->prepare($dataSql);
    $dataStmt->execute(array_merge($params, [$start, $length]));
    $data = $dataStmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode([
        'draw' => (int)$draw,
        'recordsTotal' => (int)$totalRecords,
        'recordsFiltered' => (int)$filteredRecords,
        'data' => $data
    ]);

} catch (Exception $e) {
    echo json_encode([
        'error' => true,
        'message' => $e->getMessage()
    ]);
}