<?php
require_once('../includes/connection.php');
header('Content-Type: application/json');

try {

    if (
        empty($_POST['notification_template_id']) ||
        empty($_POST['email_title']) ||
        empty($_POST['subject'])
    ) {
        echo json_encode([
            'status' => 'error',
            'message' => 'Required fields are missing'
        ]);
        exit;
    }

    $notification_template_id = base64_decode($_POST['notification_template_id']);
    $email_title   = trim($_POST['email_title']);
    $subject       = trim($_POST['subject']);
    $email_content = $_POST['email_content'] ?? '';

    $checkSql = "
        SELECT COUNT(*) 
        FROM notification_template 
        WHERE email_title = :email_title 
          AND notification_template_id != :id
    ";
    $checkStmt = $pdo->prepare($checkSql);
    $checkStmt->execute([
        ':email_title' => $email_title,
        ':id'          => $notification_template_id
    ]);

    if ($checkStmt->fetchColumn() > 0) {
        echo json_encode([
            'status' => 'error',
            'message' => 'Email Title already exists. Please use a different title.'
        ]);
        exit;
    }


    $sql = "
        UPDATE notification_template
        SET
            email_title   = :email_title,
            subject       = :subject,
            email_content = :email_content
        WHERE notification_template_id = :id
    ";

    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        ':email_title'   => $email_title,
        ':subject'       => $subject,
        ':email_content' => $email_content,
        ':id'            => $notification_template_id
    ]);


    echo json_encode([
        'status' => 'success',
        'message' => 'Email template updated successfully'
    ]);

} catch (PDOException $e) {

    echo json_encode([
        'status' => 'error',
        'message' => 'Database error: ' . $e->getMessage()
    ]);
}