<?php
$page_name = 'Bulk Upload Students';

require_once('includes/connection.php');
require_once('includes/header.php');
?>

<div class="content-wrapper">
    <section class="content-header">
        <span class="p-10">
            BULK UPLOAD STUDENTS
        </span>
        <ol class="breadcrumb">
            <li><a href="masters.php"> Masters</a></li>
            <li><a href="student_master.php">Student</a></li>
            <li class="active">Bulk Upload Students</li>
        </ol>
    </section>

    <section class="content">
        <div class="box box-default">
            <div class="box-header with-border">
                <div class="col-md-4 response-msg" id="responseMessage">
                </div>
            </div>

            <form id="bulkUploadForm" enctype="multipart/form-data">
                <div class="box-body">
                    <div class="col-md-12">

                        <div class="form-group clearfix">
                            <label class="col-md-2 col-form-label text-color"><b>Upload File</b></label>
                        </div>

                        <div class="form-group clearfix">
                            <label for="upload_file" class="col-md-2 col-form-label">Select File</label>
                            <div class="col-md-6">
                                <input class="form-control" type="file" id="upload_file" name="upload_file" accept=".csv,.xlsx,.xls" required>
                                <p class="help-block">
                                    Supported formats: Excel (.xlsx, .xls) or CSV<br>
                                    Maximum file size: 5MB<br>
                                    <strong>Note:</strong> You can upload Excel files directly. CSV files can also be opened and edited in Excel.
                                </p>
                            </div>
                        </div>

                        <div class="form-group clearfix">
                            <label class="col-md-2 col-form-label"></label>
                            <div class="col-md-6">
                                <a href="apis/download_student_template.php" class="btn btn-info">
                                    <i class="fa fa-download"></i> Download Template
                                </a>
                            </div>
                        </div>

                        <hr>

                        <div class="form-group clearfix">
                            <label class="col-md-2 col-form-label text-color"><b>File Format</b></label>
                        </div>

                        <div class="form-group clearfix">
                            <div class="col-md-10">
                                <div class="alert alert-info">
                                    <h4><i class="icon fa fa-info-circle"></i> Required Columns (in order):</h4>
                                    <ol>
                                        <li><strong>Student Name</strong> - Full name of the student (Required)</li>
                                        <li><strong>Email Address</strong> - Valid email address, must be unique (Required)</li>
                                        <li><strong>Phone Number</strong> - Exactly 10 digits, must be unique (Required)</li>
                                        <li><strong>Gender</strong> - Values: male, female, or other (Required)</li>
                                        <li><strong>Date of Birth</strong> - Format: YYYY-MM-DD (e.g., 2000-01-15) (Optional)</li>
                                        <li><strong>Institute Name</strong> - Exact name of the institute as it appears in the system (Required)</li>
                                    </ol>
                                    <p><strong>Note:</strong> The first row should contain column headers. Passwords will be auto-generated and sent via email.</p>
                                </div>
                            </div>
                        </div>

                        <div class="box-footer mt-4" style="margin-top: 30px;">
                            <button type="submit" class="btn btn-primary" id="btnUpload">
                                <i class="fa fa-upload"></i> Upload Students
                            </button>
                            <button type="button" class="btn btn-secondary" onclick="window.location.href='student_master.php'">Cancel</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>

        <!-- Error Report Section (hidden by default) -->
        <div class="box" id="errorReportSection" style="display: none; margin-top: 20px; border-top: 3px solid #f39c12;">
            <div class="box-header with-border" style="background-color: #fff3cd; border-bottom: 2px solid #ffc107;">
                <h3 class="box-title" style="color: #856404; font-weight: bold;">
                    <i class="fa fa-exclamation-triangle" style="color: #f39c12;"></i> Error Report
                </h3>
            </div>
            <div class="box-body" style="background-color: #fefefe;">
                <div class="alert" style="background-color: #fff3cd; border: 1px solid #ffc107; color: #856404; margin-bottom: 20px;">
                    <h4 style="color: #856404; margin-top: 0; margin-bottom: 10px;">
                        <i class="icon fa fa-info-circle"></i> Upload Summary
                    </h4>
                    <p id="uploadSummary" style="margin-bottom: 0; font-size: 14px; line-height: 1.6;"></p>
                </div>
                
                <div class="alert" style="background-color: #e7f3ff; border: 1px solid #b3d9ff; color: #004085; margin-bottom: 20px;">
                    <h4 style="color: #004085; margin-top: 0; margin-bottom: 15px;">
                        <i class="icon fa fa-download"></i> Download Error Report
                    </h4>
                    <p style="margin-bottom: 15px; font-size: 14px; line-height: 1.6; color: #004085;">
                        The error report CSV file contains all failed records with detailed error messages for each record.
                    </p>
                    <div id="errorReportDownload" style="margin-bottom: 20px; text-align: center;">
                        <!-- Download button will be inserted here -->
                    </div>
                    <div style="background-color: #ffffff; padding: 20px; border-radius: 4px; border-left: 4px solid #2196F3; box-shadow: 0 1px 3px rgba(0,0,0,0.1);">
                        <h5 style="margin-top: 0; margin-bottom: 15px; color: #1976D2; font-weight: bold;">
                            <i class="fa fa-list-ol"></i> Instructions to Fix Errors:
                        </h5>
                        <ol style="margin-bottom: 0; padding-left: 20px; color: #333; line-height: 1.8;">
                            <li style="margin-bottom: 8px;">Click the download button above to download the error report CSV file</li>
                            <li style="margin-bottom: 8px;">Open the CSV file in Excel or any spreadsheet application</li>
                            <li style="margin-bottom: 8px;">Review the "Error Message" column to understand what needs to be fixed</li>
                            <li style="margin-bottom: 8px;">Fix all the errors in the data (e.g., correct email format, phone numbers, institute names, etc.)</li>
                            <li style="margin-bottom: 8px;"><strong style="color: #d32f2f;">Delete the "Error Message" column</strong> from the file</li>
                            <li>Save the file and upload it again using the form above</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<?php require_once('includes/footer.php'); ?>

<script>
$(document).ready(function () {
    
    $('#bulkUploadForm').on('submit', function (event) {
        event.preventDefault();

        const $uploadBtn = $('#btnUpload');
        const fileInput = $('#upload_file')[0];
        
        // Validate file
        if (!fileInput.files || !fileInput.files[0]) {
            showAlert('Please select a file to upload.', 'danger');
            return;
        }

        const file = fileInput.files[0];
        const maxSize = 5 * 1024 * 1024; // 5MB
        
        if (file.size > maxSize) {
            showAlert('File size exceeds 5MB limit. Please upload a smaller file.', 'danger');
            return;
        }

        const allowedExtensions = ['csv', 'xlsx', 'xls'];
        const fileExtension = file.name.split('.').pop().toLowerCase();
        
        if (!allowedExtensions.includes(fileExtension)) {
            showAlert('Invalid file format. Please upload CSV or Excel file (.csv, .xlsx, .xls).', 'danger');
            return;
        }

        // Disable button and show loading
        $uploadBtn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Uploading...');

        // Create FormData
        const formData = new FormData();
        formData.append('upload_file', file);

        $.ajax({
            url: 'apis/bulk_upload_students_api.php',
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            dataType: 'json',
            success: function (data) {
                // Hide error report section first
                $('#errorReportSection').hide();
                
                if (data.status === 'success') {
                    showAlert(data.message, 'success');
                    $('#bulkUploadForm')[0].reset();
                    
                    // Redirect to student master after 2 seconds
                    setTimeout(function() {
                        window.location.href = 'student_master.php';
                    }, 2000);
                } else {
                    // Show summary in alert
                    showAlert(data.message, data.status === 'error' ? 'danger' : 'warning');
                    
                    // Show error report section on page if error report is available
                    if (data.error_report_file) {
                        const downloadUrl = 'apis/download_error_report.php?file=' + encodeURIComponent(data.error_report_file);
                        
                        // Update upload summary
                        let summaryText = '';
                        if (data.success_count > 0) {
                            summaryText = 'Successfully added <strong>' + data.success_count + '</strong> student(s). ';
                        }
                        summaryText += '<strong>' + data.error_count + '</strong> record(s) failed. Please download the error report below to see all error details.';
                        $('#uploadSummary').html(summaryText);
                        
                        // Add download button
                        $('#errorReportDownload').html(
                            '<a href="' + downloadUrl + '" class="btn btn-warning btn-lg" download style="padding: 12px 30px; font-size: 16px; font-weight: bold; box-shadow: 0 2px 4px rgba(0,0,0,0.2);">' +
                            '<i class="fa fa-file-excel-o"></i> Download Error Report (' + data.error_count + ' failed records)' +
                            '</a>'
                        );
                        
                        // Show error report section
                        $('#errorReportSection').slideDown();
                        
                        // Scroll to error report section
                        $('html, body').animate({
                            scrollTop: $('#errorReportSection').offset().top - 100
                        }, 500);
                    }
                }
                $uploadBtn.prop('disabled', false).html('<i class="fa fa-upload"></i> Upload Students');
            },
            error: function (xhr, status, error) {
                console.error('Error:', error);
                showAlert('An error occurred while uploading the file. Please try again.', 'danger');
                $uploadBtn.prop('disabled', false).html('<i class="fa fa-upload"></i> Upload Students');
            }
        });
    });
});
</script>

</body>
</html>

