<?php
$page_name = 'Course Category List';
require_once('includes/connection.php');
require_once('includes/header.php');

$category_session = $_SESSION['category'];

$decoded_category_id = null;
if (isset($_GET['category_id'])) {
    $decoded_category_id = base64_decode($_GET['category_id']);
}
?>

<div id="page-loader" style="display:none;">
    <div class="loader" id="loader-2">
        <span></span><span></span><span></span>
    </div>
</div>

<div class="content-wrapper">
    <section class="content-header">
        <span style="margin-left: 10px;" id="category_name"></span>
        <ol class="breadcrumb">
            <li><a href="masters.php">Masters</a></li>
            <li class="active">Course Category</li>
        </ol>
    </section>

    <section class="content">
        <div class="box box-default">
            <div class="box-header with-border">
                <div class="col-md-4 response-msg" id="responseMessage"></div>
                <div class="box-body table-padding">
                    <table id="dataGrid" class="table display">
                        <thead style="background: #FAF7FE;">
                            <tr>
                                <th>Sr. No.</th>
                                <th>Course Name</th>
                                <th>No Of Licenses</th>
                                <th>Course Fees</th>
                                <th>Start Date</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
    </section>
</div>


<div class="modal fade" id="approveCourseModal">
    <div class="modal-dialog">
        <div class="modal-content">

            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">Approve / Reject Course</h4>
            </div>

            <div class="modal-body">
                <form id="approveCourseForm">
                    <input type="hidden" name="course_id" id="approve_course_id">

                    <div class="form-group">
                        <label>Status</label>
                        <select name="status" class="form-control" required>
                            <option value="">-- Select --</option>
                            <option value="approved">Approve</option>
                            <option value="rejected">Reject</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label>Comment</label>
                        <textarea name="comment" class="form-control" rows="4"
                                  placeholder="Enter approval / rejection comment"></textarea>
                    </div>
                </form>
            </div>

            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-primary" id="submitApproval">Submit</button>
            </div>

        </div>
    </div>
</div>

<?php require_once('includes/footer.php'); ?>

<script>
const selectedCategoryId = <?php echo json_encode($decoded_category_id); ?>;
const userCategory = '<?php echo $category_session; ?>';
const loggedInUserId = <?php echo isset($_SESSION['user_id']) ? $_SESSION['user_id'] : 0; ?>;

$(document).ready(function () {
    // Initialize Bootstrap tooltips
    $('[data-toggle="tooltip"]').tooltip();
    
    const dataTable = $('#dataGrid').DataTable({
        processing: true,
        serverSide: true,
        ordering: false,
        language: { search: "Search:" },
        ajax: {
            url: 'apis/course_api.php',
            type: 'POST',
            data: function (d) {
                d.sortField = $('#sortField').val();
                d.sortDir = 'asc';
                d.category_id = selectedCategoryId;
            },
            beforeSend: function () {
                $('#page-loader').show();
            },
            complete: function (xhr) {
                $('#page-loader').hide();
                try {
                    const response = JSON.parse(xhr.responseText);
                    const data = response.data || [];
                    if (data.length === 0) {
                        $('#category_name').text("Category Name: Not Found");
                    } else {
                        $('#category_name').text("Category Name: " + data[0].course_category);
                    }
                } catch (e) {
                    $('#category_name').text("Category Name: Not Found");
                }
                
                // Initialize tooltips after table is drawn
                $('[data-toggle="tooltip"]').tooltip();
            },
            error: function (xhr, error, thrown) {
                console.error('Error loading data:', thrown);
            }
        },
        columns: [
            { data: null, render: (data, type, row, meta) => meta.row + meta.settings._iDisplayStart + 1 },
            { data: 'course_title' },
            { data: 'no_of_licenses' },
            { data: 'course_fees' },
            { data: 'start_date' },
            {
                data: 'expert_approval_status',
                render: (status, type, row) => {
                    let statusBadge = '';
                    let tooltipText = '';
                    
                    if (status === 'approved') {
                        const approvedDate = row.expert_approved_at ? new Date(row.expert_approved_at).toLocaleDateString() : 'N/A';
                        const expertName = row.expert_name || 'Industry Expert';
                        tooltipText = `Approved by ${expertName} on ${approvedDate}`;
                        statusBadge = `<span class="status-badge approved" 
                                           style="background: #28a745; color: white; padding: 5px 10px; border-radius: 4px; font-size: 12px; font-weight: 500; cursor: help;" 
                                           title="${tooltipText}"
                                           data-toggle="tooltip" 
                                           data-placement="top">
                                           <i class="fa fa-check-circle" style="margin-right: 4px;"></i>Approved
                                       </span>`;
                    } else if (status === 'rejected') {
                        const rejectedDate = row.expert_approved_at ? new Date(row.expert_approved_at).toLocaleDateString() : 'N/A';
                        const expertName = row.expert_name || 'Industry Expert';
                        const comment = row.expert_approval_comment || 'No comment provided';
                        tooltipText = `Rejected by ${expertName} on ${rejectedDate}\nReason: ${comment}`;
                        statusBadge = `<span class="status-badge rejected" 
                                           style="background: #dc3545; color: white; padding: 5px 10px; border-radius: 4px; font-size: 12px; font-weight: 500; cursor: help;" 
                                           title="${tooltipText.replace(/\n/g, ' - ')}"
                                           data-toggle="tooltip" 
                                           data-placement="top">
                                           <i class="fa fa-times-circle" style="margin-right: 4px;"></i>Rejected
                                       </span>`;
                    } else {
                        tooltipText = 'Waiting for industry expert approval';
                        statusBadge = `<span class="status-badge pending" 
                                           style="background: #ffc107; color: #333; padding: 5px 10px; border-radius: 4px; font-size: 12px; font-weight: 500; cursor: help;" 
                                           title="${tooltipText}"
                                           data-toggle="tooltip" 
                                           data-placement="top">
                                           <i class="fa fa-clock-o" style="margin-right: 4px;"></i>Pending
                                       </span>`;
                    }
                    
                    return statusBadge;
                }
            },
            {
                data: 'course_id',
                render: (id, type, row) => {
                    const encId = btoa(id.toString());
                    const startDate = row.start_date;
                    const current_date = new Date().toISOString().split('T')[0];
                    let actions = ``;
                    const isExpert = (userCategory === 'expert');
                    const isMentor = (userCategory === 'mentor');
                    const isAdmin = (userCategory === 'superadmin');
                    
                    // Check if mentor can edit/publish this course (only if they created it)
                    const canMentorEdit = !isMentor || (isMentor && row.created_by == loggedInUserId);

                    // Only show approve/reject button to industry experts
                    if (isExpert) {
                        actions += `
                        <a href="javascript:void(0);">
                            <i class="fa fa-check-square-o approve-course"
                                    data-course-id="${id}" style="margin-left: 10px; background: #5D2B8B; border-radius: 50%; padding: 7px; color: #fff; font-size: 12px;" 
                                           title="Approve / Reject Course">
                            </i>
                        </a>    
                        `;
                    }

                    // Show edit button: for non-experts, if start date is in future, AND if mentor, only if they created it, AND course is not approved
                    if (!isExpert && startDate > current_date && canMentorEdit && row.expert_approval_status !== 'approved') {
                        actions += `<a href="add_course.php?course=${encId}">
                                        <img src="images/edit.svg" style="margin-left: 10px;" title="Edit" />
                                    </a>`;
                    }

                    actions += `<a href="course_details.php?id=${encId}" target="_blank">
                                    <img src="images/view.svg" style="margin-left: 10px; width: 24px;" title="View Course" />
                                </a>`;

                    if (isAdmin) {
                        actions += `<a href="javascript:void(0);" class="delete-course" data-course-id="${id}">
                                        <img src="images/delete.svg" style="margin-left: 10px; width: 24px;" title="Delete Course" />
                                    </a>`;
                    }

                    // Publish course: only for non-experts, and if mentor, only if they created it
		    if (!isExpert && canMentorEdit) {
                    if (row.is_publish == 1) {
                        actions += `<span style="margin-left: 10px; color: green; font-weight: bold;">Published</span>`;
                    } else {
                        // Only show publish button if course is approved
                        if (row.expert_approval_status === 'approved') {
                            actions += `<a href="javascript:void(0);">
                                            <i class="fa fa-upload publish-course" 
                                               data-course-id="${id}" 
                                               style="margin-left: 10px; background: #5D2B8B; border-radius: 50%; padding: 7px; color: #fff; font-size: 12px;" 
                                               title="Publish Course"></i>
                                        </a>`;
                        } else {
                            actions += `<span style="margin-left: 10px; color: #999; font-size: 11px;" title="Course must be approved before publishing">Publish (Not Available)</span>`;
                        }
                    }
                    }

                    return actions;
                }
            }
        ],
        initComplete: function () {
            const searchInput = $('#dataGrid_filter input');
            const searchWidth = searchInput.outerWidth();
            const sortHtml = `<label style="margin-left: 10px;">
                                Sort By:
                                <select id="sortField" class="form-control input-sm" style="width: ${searchWidth}px; display:inline-block; margin-left:5px;">
                                    <option value="course_title">Course Name</option>
                                    <option value="no_of_licenses">Licenses</option>
                                    <option value="course_fees">Course Fees</option>
                                    <option value="start_date">Start Date</option>
                                </select>
                              </label>`;
            $('#dataGrid_filter').append(sortHtml);
        }
    });

    // Duplicate course
    $('#dataGrid').on('click', '.duplicate-course', function () {
        const courseId = $(this).data('course-id');
        if (confirm("Are you sure you want to duplicate this course?")) {
            $.post('apis/duplicate_course_api.php', { course_id: courseId }, function (data) {
                if (data.status === 'success') {
                    dataTable.ajax.reload();
                    showAlert(data.message, 'success');
                } else {
                    showAlert(data.message, 'danger');
                }
            }, 'json').fail(() => {
                showAlert('Failed to duplicate course. Please try again.', 'danger');
            });
        }
    });

    // Delete course
    $('#dataGrid').on('click', '.delete-course', function () {
        const courseId = $(this).data('course-id');
        if (!confirm("Are you sure you want to delete this course?")) return;

        $.ajax({
            url: 'apis/delete_course_api.php',
            method: 'POST',
            data: { course_id: courseId },
            dataType: 'json',
            success: function (response) {
                if (response.success) {
                    showAlert(response.message, 'success');
                    dataTable.ajax.reload();
                } else {
                    showAlert(response.message, 'danger');
                }
            },
            error: function () {
                showAlert('An error occurred while deleting the course.', 'danger');
            }
        });
    });

    // Sort change
    $(document).on('change', '#sortField', function () {
        dataTable.ajax.reload();
    });

    // Publish course - only send course_id, nothing else
    $(document).on('click', '.publish-course', function () {
        const btn = $(this);
        const courseId = btn.data('course-id');
        if (!courseId) return alert('Error: No course ID found.');
        if (!confirm('Are you sure you want to publish this course?')) return;

        $.ajax({
            url: 'apis/publish_course_api.php',
            method: 'POST',
            data: { course_id: courseId },
            dataType: 'json',
            success: function (response) {
                if (response.success) {
                    showAlert(response.message, 'success');
                    dataTable.ajax.reload();
                } else {
                    showAlert(response.message, 'danger');
                }
            },
            error: function () {
                alert('An error occurred while trying to publish the course.');
            }
        });
    });
    

    // Open approve modal
    $(document).on('click', '.approve-course', function () {
        const courseId = $(this).data('course-id');
        $('#approve_course_id').val(courseId);
        
        // Get current course data from DataTable to pre-populate modal
        const rowData = dataTable.row($(this).closest('tr')).data();
        if (rowData) {
            // Pre-populate status dropdown with current status (allows expert to change mind)
            const currentStatus = rowData.expert_approval_status || '';
            $('#approveCourseForm select[name="status"]').val(currentStatus);
            
            // Pre-populate comment if exists
            const currentComment = rowData.expert_approval_comment || '';
            $('#approveCourseForm textarea[name="comment"]').val(currentComment);
        } else {
            // Reset form if data not available
            $('#approveCourseForm select[name="status"]').val('');
            $('#approveCourseForm textarea[name="comment"]').val('');
        }
        
        $('#approveCourseModal').modal('show');
    });

    // Submit approve/reject
    $('#submitApproval').on('click', function () {
        const formData = $('#approveCourseForm').serialize();
        
        // Validate form before submission
        const status = $('#approveCourseForm select[name="status"]').val();
        if (!status) {
            showAlert('Please select approval status.', 'danger');
            return;
        }
        
        if (status === 'rejected') {
            const comment = $('#approveCourseForm textarea[name="comment"]').val().trim();
            if (!comment) {
                showAlert('Comment is required for rejection.', 'danger');
                return;
            }
        }
        
        $.ajax({
            url: 'apis/approve_reject_course_api.php',
            type: 'POST',
            data: formData,
            dataType: 'json',
            success: function (res) {
                if (res.success) {
                    $('#approveCourseModal').modal('hide');
                    $('#approveCourseForm')[0].reset();
                    dataTable.ajax.reload(null, false);
                    showAlert(res.message, 'success');
                    
                    // Re-initialize tooltips after reload
                    setTimeout(function() {
                        $('[data-toggle="tooltip"]').tooltip();
                    }, 500);
                } else {
                    showAlert(res.message, 'danger');
                }
            },
            error: function (xhr, status, error) {
                console.error('AJAX Error:', status, error);
                let errorMessage = 'An error occurred while processing your request.';
                try {
                    const response = JSON.parse(xhr.responseText);
                    if (response.message) {
                        errorMessage = response.message;
                    }
                } catch (e) {
                    // If response is not JSON, use default message
                }
                showAlert(errorMessage, 'danger');
            }
        });
    });    

});
</script>




</body>
</html>