<?php 
$page_name = 'Course List';

require_once('includes/connection.php');
require_once('includes/header.php');
?>

  <div class="content-wrapper">
    <section class="content-header">
      <span style="margin-left: 10px;">
        Course Master
      </span>
      <ol class="breadcrumb">
        <li><a href="masters.php"> Masters</a></li>
        <li class="active">Course</li>
      </ol>
    </section>

    <section class="content">
        <div class="box box-default">
            <div class="box-header with-border">
            <div class="col-md-4 response-msg" id="responseMessage"></div>
                <div class="box-body table-padding">
                    <div id="loader" style="display: none;">
                    <p>Loading...</p>
                    </div>
                    <div id="courseContainer" class="row"></div>
                </div>
            </div>
        </div>
    </section>
  </div>
  
<?php require_once('includes/footer.php'); ?>

<style>
/* ✅ Ellipsis for long course names */
.custom-info-box-text {
  display: inline-block;
  max-width: 180px;  /* adjust according to card width */
  white-space: nowrap;
  overflow: hidden;
  text-overflow: ellipsis;
  vertical-align: middle;
}
</style>
  
<script>
// Function to encode ID using Base64
function encodeId(id) {
    return btoa(id.toString());
}

// Function to fetch data from the PHP API using jQuery
function fetchData() {
    $('#loader').show();

    $.ajax({
        url: 'cr/course_category_card_mentor_api.php',
        method: 'GET',
        dataType: 'json',
        success: function (data) {
            const courseContainer = $('#courseContainer');
            courseContainer.empty();

            const categoryData = {};

            // Group courses by category_id (exclude drafts/no category)
            data.forEach(course => {
                const categoryId = course.category_id;
                const categoryName = course.course_category;

                if (!categoryId || !categoryName) {
                    // ✅ skip drafts / no category
                    return;
                }

                if (!categoryData[categoryId]) {
                    categoryData[categoryId] = {
                        name: categoryName,
                        count: 0
                    };
                }
                categoryData[categoryId].count++;
            });

            // Create cards for each category
            for (const [categoryId, details] of Object.entries(categoryData)) {
                const encryptedId = encodeId(categoryId);
                const card = $(`
                    <div class="col-md-3 col-sm-6 col-xs-12">
                        <div class="custom-info-box p-3 border rounded d-flex justify-content-between align-items-center category-card"
                             data-category-id="${encryptedId}">
                            <div class="custom-info-box-content">
                                <!-- ✅ Tooltip with full name -->
                                <span class="custom-info-box-text" title="${details.name}">${details.name}</span>
                            </div>
                            <span class="custom-info-box-icon bg-card">${details.count}</span>
                        </div>
                    </div>
                `);
                courseContainer.append(card);
            }

            $('#loader').hide();
        },
        error: function (error) {
            console.error('Error fetching data:', error);
            $('#loader').hide();
        }
    });
}

// Click event handler for category cards
$('#courseContainer').on('click', '.category-card', function () {
    const categoryId = $(this).data('category-id');
    window.location.href = 'course_category_master.php?category_id=' + categoryId;
});

// Duplicate course handler
$('#dataGrid').on('click', '.duplicate-course', function () {
    const courseId = $(this).data('course-id');

    if (confirm("Are you sure you want to duplicate this course?")) {
        $.ajax({
            url: 'apis/duplicate_course_api.php',
            method: 'POST',
            data: { course_id: courseId },
            success: function (data) {
                if (data.status === 'success') {
                    fetchData();
                    showAlert(data.message, 'success');
                } else {
                    showAlert(data.message, 'danger');
                }
            },
            error: function (error) {
                console.error('Error duplicating course:', error);
                showAlert('Failed to duplicate course. Please try again.', 'danger');
            }
        });
    }
});


// Fetch data on page load
$(document).ready(function () {
    fetchData();
});
</script>

</body>
</html>