<?php
require_once('../includes/connection.php');
header('Content-Type: application/json');

try {
    $data = json_decode(file_get_contents("php://input"), true);

    if (!isset($data['submodule_ids']) || !is_array($data['submodule_ids'])) {
        echo json_encode(["status" => "error", "message" => "Submodule IDs are required."]);
        exit;
    }

    $course_id = $data['course_id'];
    $module_id = $data['module_id'];
    $incomingSubmodules = $data['submodule_ids'];

    // Get current modules from DB for this course
    $existingSubmodulesStmt = $pdo->prepare("SELECT submodule_id FROM course_submodule WHERE course_id = :course_id");
    $existingSubmodulesStmt->execute([':course_id' => $course_id]);
    $existingSubmodules = $existingSubmodulesStmt->fetchAll(PDO::FETCH_COLUMN);

    $inserted = [];
    $duplicates = [];
    $deleted = [];

    // Add new modules or mark duplicates
    foreach ($incomingSubmodules as $submodule_id) {
        if (in_array($submodule_id, $existingSubmodules)) {
            $duplicates[] = $submodule_id;
        } else {
            $insertStmt = $pdo->prepare("INSERT INTO course_submodule (submodule_id, module_id, course_id) VALUES (:submodule_id, :module_id, :course_id)");
            $insertStmt->execute([
                ':module_id' => $module_id,
                ':course_id' => $course_id,
                ':submodule_id' => $submodule_id
            ]);
            $inserted[] = $submodule_id;
        }
    }

    // Remove modules that are in DB but not in incoming list
    foreach ($existingSubmodules as $submodule_id) {
        if (!in_array($submodule_id, $incomingSubmodules)) {
            $deleteStmt = $pdo->prepare("DELETE FROM course_submodule WHERE course_id = :course_id AND submodule_id = :submodule_id");
            $deleteStmt->execute([
                ':course_id' => $course_id,
                ':submodule_id' => $submodule_id
            ]);
            $deleted[] = $submodule_id;
        }
    }

    // Build message
    $messages = [];
    if (!empty($inserted)) $messages[] = count($inserted) . " submodule(s) added successfully.";
    //if (!empty($duplicates)) $messages[] = count($duplicates) . " module(s) were already assigned";
    if (!empty($deleted)) $messages[] = count($deleted) . " submodule(s) removed.";

    echo json_encode([
        "status" => "success",
        "inserted" => $inserted,
        "duplicates" => $duplicates,
        "deleted" => $deleted,
        "message" => implode(" ", $messages)
    ]);

} catch (PDOException $e) {
    echo json_encode([
        "status" => "error",
        "message" => "Database Error: " . $e->getMessage()
    ]);
}
?>