<?php
require_once('../includes/connection.php');
header('Content-Type: application/json');

$user_id = $_SESSION['user_id'] ?? null;
$institute_id = $_SESSION['institute_id'] ?? null;

try {
    // Use $_POST for jQuery AJAX
    if (!isset($_POST['module_name']) || empty(trim($_POST['module_name']))) {
        echo json_encode(["status" => "error", "message" => "Module name is required."]);
        exit;
    }
    
    if (!isset($_POST['course_id']) || empty(trim($_POST['course_id']))) {
        echo json_encode(["status" => "error", "message" => "Course ID is required."]);
        exit;
    }    

    $module_name = trim($_POST['module_name']);
    $course_id = trim($_POST['course_id']);


    $checkSql = "SELECT module_name FROM module_master WHERE module_name = :module_name AND institute_id = :institute_id";
    $checkStmt = $pdo->prepare($checkSql);
    $checkStmt->execute([
        ':module_name' => $module_name,
        ':institute_id' => $institute_id
    ]);

    if ($checkStmt->fetch()) {
        echo json_encode([
            "status" => "error",
            "message" => "A module with this name already exists for this course."
        ]);
        exit;
    }
    
    
    // Insert into module_master
    $insertModuleSql = "INSERT INTO module_master (module_name, institute_id, created_by) VALUES (:module_name, :institute_id, :created_by)";
    $stmt = $pdo->prepare($insertModuleSql);
    $stmt->bindParam(':module_name', $module_name);
    $stmt->bindParam(':institute_id', $institute_id);
    $stmt->bindParam(':created_by', $user_id);
    $stmt->execute();

    // Get the newly inserted module_id
    $newModuleId = $pdo->lastInsertId();

    // Get current max sequence for this course_id
    $seqStmt = $pdo->prepare("SELECT MAX(sequence) FROM course_module WHERE course_id = :course_id");
    $seqStmt->execute([':course_id' => $course_id]);
    $maxSequence = $seqStmt->fetchColumn();
    $nextSequence = $maxSequence ? $maxSequence + 1 : 1;

    // Insert into course_module with sequence
    $insertCourseModuleSql = "INSERT INTO course_module (module_id, course_id, sequence) VALUES (:module_id, :course_id, :sequence)";
    $stmt2 = $pdo->prepare($insertCourseModuleSql);
    $stmt2->bindParam(':module_id', $newModuleId);
    $stmt2->bindParam(':course_id', $course_id);
    $stmt2->bindParam(':sequence', $nextSequence);
    $stmt2->execute();

    echo json_encode([
        "status" => "success",
        "message" => "Module created and assigned successfully.",
        "module_id" => $newModuleId,
        "sequence" => $nextSequence
    ]);

} catch (PDOException $e) {
    echo json_encode([
        "status" => "error",
        "message" => "Database Error: " . $e->getMessage()
    ]);
}
?>