<?php
require_once('../includes/connection.php');
header('Content-Type: application/json');

try {
    $data = json_decode(file_get_contents('php://input'), true);

    $course_id     = $data['course_id'] ?? '';
    $assignment_id = $data['assignment_id'] ?? '';

    if (!$course_id) {
        echo json_encode(['status' => 'error', 'message' => 'Missing required fields.']);
        exit;
    }

    // ---------------- Fetch existing assignment for this course ----------------
    $checkSql = "SELECT course_assignment_id, assignment_id 
                 FROM course_assignment 
                 WHERE course_id = :course_id";
    $stmt = $pdo->prepare($checkSql);
    $stmt->execute([':course_id' => $course_id]);
    $existing = $stmt->fetch(PDO::FETCH_ASSOC);

    $selectedAssignment = null;

    if ($existing) {
        $selectedAssignment = $existing['assignment_id'];

        // If assignment_id is provided and different, update it
        if ($assignment_id && $existing['assignment_id'] != $assignment_id) {
            $updateSql = "UPDATE course_assignment 
                          SET assignment_id = :assignment_id
                          WHERE course_assignment_id = :course_assignment_id";
            $stmt = $pdo->prepare($updateSql);
            $stmt->execute([
                ':assignment_id' => $assignment_id,
                ':course_assignment_id' => $existing['course_assignment_id']
            ]);
            $selectedAssignment = $assignment_id; // updated
            $message = 'Assignment updated successfully.';
        } else {
            $message = 'Assignment already assigned.';
        }
    } else {
        // Insert new record if assignment_id provided
        if ($assignment_id) {
            $insertSql = "INSERT INTO course_assignment (assignment_id, course_id) 
                          VALUES (:assignment_id, :course_id)";
            $stmt = $pdo->prepare($insertSql);
            $stmt->execute([
                ':assignment_id' => $assignment_id,
                ':course_id' => $course_id
            ]);
            $selectedAssignment = $assignment_id;
            $message = 'Assignment assigned successfully.';
        } else {
            $message = 'No assignment assigned yet.';
        }
    }

    echo json_encode([
        'status' => 'success',
        'message' => $message,
        'selectedAssignment' => $selectedAssignment
    ]);

} catch (Exception $e) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Server error: ' . $e->getMessage()
    ]);
}
?>
