<?php
require_once('../includes/connection.php');
header('Content-Type: application/json');

try {
    $data = json_decode(file_get_contents('php://input'), true);

    $course_id     = $data['course_id'] ?? '';
    $module_id     = $data['module_id'] ?? '';
    $submodule_id  = $data['submodule_id'] ?? 0;
    $quiz_id       = $data['quiz_id'] ?? '';

    if (!$course_id || !$module_id || !$quiz_id) {
        echo json_encode(['status' => 'error', 'message' => 'Missing required fields.']);
        exit;
    }

    // Check if quiz already assigned to this course
    $checkQuizSql = "SELECT COUNT(*) AS total, course_quiz_id 
                     FROM course_quiz 
                     WHERE quiz_id = :quiz_id AND course_id = :course_id";
    $stmt = $pdo->prepare($checkQuizSql);
    $stmt->execute([
        ':quiz_id' => $quiz_id,
        ':course_id' => $course_id
    ]);
    $quizRow = $stmt->fetch(PDO::FETCH_ASSOC);
    $count = (int)$quizRow['total'];
    $course_quiz_id = $quizRow['course_quiz_id'] ?? null;

    if ($count > 0 && $course_quiz_id) {
        // Update existing record
        $updateSql = "UPDATE course_quiz 
                      SET module_id = :module_id, submodule_id = :submodule_id 
                      WHERE course_quiz_id = :course_quiz_id AND quiz_id = :quiz_id AND course_id = :course_id";
        $stmt = $pdo->prepare($updateSql);
        $stmt->execute([
            ':module_id' => $module_id,
            ':submodule_id' => $submodule_id,
            ':quiz_id' => $quiz_id,
            ':course_quiz_id' => $course_quiz_id,
            ':course_id' => $course_id
        ]);
        echo json_encode(['status' => 'success', 'message' => 'Quiz assigned successfully.']);
    } 
    else {
        // Insert new record
        $insertSql = "INSERT INTO course_quiz (module_id, course_id, submodule_id, quiz_id) 
                      VALUES (:module_id, :course_id, :submodule_id, :quiz_id)";
        $stmt = $pdo->prepare($insertSql);
        $stmt->execute([
            ':module_id' => $module_id,
            ':course_id' => $course_id,
            ':submodule_id' => $submodule_id,
            ':quiz_id' => $quiz_id
        ]);
        echo json_encode(['status' => 'success', 'message' => 'Quiz assigned successfully.']);
    }

} catch (Exception $e) {
    echo json_encode(['status' => 'error', 'message' => 'Server error: ' . $e->getMessage()]);
}
?>