<?php
require_once ('../includes/connection.php');
session_start();

$institute_id = $_SESSION['institute_id'];
$category = $_SESSION['category'];
$user_id = $_SESSION['user_id'];

try {

    $mentor_id = null;
    $isExpert  = 0;

    if ($category === 'mentor' || $category === 'expert') {
        $stmtRole = $pdo->prepare("
            SELECT mentor_id, industry_expert
            FROM mentor_master
            WHERE user_id = :user_id
        ");
        $stmtRole->execute(['user_id' => $user_id]);
        $mentorData = $stmtRole->fetch(PDO::FETCH_ASSOC);

        if ($mentorData) {
            $mentor_id = $mentorData['mentor_id'];
            $isExpert  = (int)$mentorData['industry_expert'];
        }
    }
    
    
    $sql = "SELECT 
                c.course_id,
                c.course_title,
                cm.category_name AS course_category,
                c.level,
                c.created_date,
                c.created_by,
                c.institute_id,
                cm.category_id,
                im.institute_name
            FROM course_master c
            LEFT JOIN category_master cm ON c.course_category = cm.category_id
            LEFT JOIN institute_master im ON c.institute_id = im.institute_id
            WHERE c.institute_id = :institute_id AND c.is_block = 0";
    
    if ($category === 'mentor' && $mentor_id && $isExpert === 0) {
        $sql .= " AND FIND_IN_SET(:mentor_id, c.mentor_ids)";
    }

    if ($category === 'expert' && $mentor_id && $isExpert === 1) {
        $sql .= " AND FIND_IN_SET(:mentor_id, c.industry_expert_ids)";
    }
    

     $sql .= " ORDER BY c.course_id DESC";

    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':institute_id', $institute_id, PDO::PARAM_INT);

    if (($category === 'mentor' || $category === 'expert') && $mentor_id) {
        $stmt->bindParam(':mentor_id', $mentor_id, PDO::PARAM_INT);
    }

    $stmt->execute();
    $data = $stmt->fetchAll(PDO::FETCH_ASSOC);

    header('Content-Type: application/json');
    echo json_encode($data);
}
catch (PDOException $e) {
    echo json_encode(['error' => 'Database connection failed: ' . $e->getMessage()]);
}
?>