<?php
require_once('../includes/connection.php');
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $module_id = intval($_POST['module_id'] ?? 0);

        if (!$module_id) {
            echo json_encode(['status' => 'error', 'message' => 'Missing module_id']);
            exit;
        }

        // Delete from course_module
        $stmt = $pdo->prepare("DELETE FROM course_module WHERE module_id = :module_id");
        $stmt->bindParam(':module_id', $module_id);
        $stmt->execute();

        echo json_encode(['status' => 'success', 'message' => 'Module removed from course']);
    } catch (PDOException $e) {
        echo json_encode(['status' => 'error', 'message' => 'DB Error: ' . $e->getMessage()]);
    }
    exit;
}

echo json_encode(['status' => 'error', 'message' => 'Invalid request']);
exit;
