<?php
require_once('../includes/connection.php');
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $submodule_id = intval($_POST['submodule_id'] ?? 0);

        if (!$submodule_id) {
            echo json_encode(['status' => 'error', 'message' => 'Missing submodule_id']);
            exit;
        }

        // Delete from course_module
        $stmt = $pdo->prepare("DELETE FROM course_submodule WHERE submodule_id = :submodule_id");
        $stmt->bindParam(':submodule_id', $submodule_id);
        $stmt->execute();

        echo json_encode(['status' => 'success', 'message' => 'Submodule removed from course']);
    } catch (PDOException $e) {
        echo json_encode(['status' => 'error', 'message' => 'DB Error: ' . $e->getMessage()]);
    }
    exit;
}

echo json_encode(['status' => 'error', 'message' => 'Invalid request']);
exit;
