<?php
session_start();
require_once('../includes/connection.php');
header('Content-Type: application/json');

$course_id = $_GET['course_id'] ?? null;
$user_id = isset($_SESSION['user_id']) ? $_SESSION['user_id'] : null;
$user_category = isset($_SESSION['category']) ? $_SESSION['category'] : null;

if (!$course_id) {
    echo json_encode(['status' => 'error', 'message' => 'Course ID is required']);
    exit;
}

try {
    $stmt = $pdo->prepare("
        SELECT cm.*, im.folder_name
        FROM course_master cm
        JOIN institute_master im ON cm.institute_id = im.institute_id
        WHERE cm.course_id = ?
    ");
    $stmt->execute([$course_id]);
    $course = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$course) {
        echo json_encode(['status' => 'error', 'message' => 'Course not found']);
        exit;
    }
    
    // If user is mentor, check if they created this course
    if ($user_category === 'mentor' && $user_id) {
        if ($course['created_by'] != $user_id) {
            echo json_encode(['status' => 'error', 'message' => 'You can only edit courses that you created.']);
            exit;
        }
    }


    // Convert comma-separated fields to arrays for JS
    $course['mentor_ids'] = $course['mentor_ids'] ? explode(',', $course['mentor_ids']) : [];
    $course['industry_expert_ids'] = $course['industry_expert_ids'] ? explode(',', $course['industry_expert_ids']) : [];
    $course['testimonials'] = $course['testimonials'] ? explode(',', $course['testimonials']) : [];
    $course['proposed_courses'] = $course['proposed_courses'] ? explode(',', $course['proposed_courses']) : [];
    $course['faq_ids'] = $course['faq_ids'] ? explode(',', $course['faq_ids']) : [];

    echo json_encode(['status' => 'success', 'data' => $course]);
}
 catch (PDOException $e) {
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
?>