<?php
require_once('../includes/connection.php');
header('Content-Type: application/json');

$institute_id = $_SESSION['institute_id'];
$course_id = $_POST['course_id'] ?? null;  // Optional course_id

try {
    $draw = $_POST['draw'] ?? 1;
    $start = (int)($_POST['start'] ?? 0);
    $length = (int)($_POST['length'] ?? 10);
    $searchValue = $_POST['search']['value'] ?? '';
    $sortField = $_POST['sortField'] ?? 'qm.quiz_id';
    $sortDir = strtoupper($_POST['sortDir'] ?? 'DESC');

    $allowedSortFields = ['qm.quiz_title', 'qm.is_block', 'qm.quiz_id'];
    if (!in_array($sortField, $allowedSortFields)) {
        $sortField = 'qm.quiz_id';
    }

    // Base WHERE clause (institute + status)
    $whereClause = "WHERE qm.is_deleted !=1 AND qm.is_block != 1 AND (qm.institute_id = :institute_id OR qm.institute_id = 0)";
    $params = [':institute_id' => $institute_id];

    if (!empty($searchValue)) {
        $whereClause .= " AND qm.quiz_title LIKE :search";
        $params[':search'] = '%' . $searchValue . '%';
    }

    // Total records (no filter)
    $totalQuery = "
        SELECT COUNT(*) 
        FROM quiz_master qm 
        WHERE qm.is_block != 1 AND (qm.institute_id = :institute_id OR qm.institute_id = 0)
    ";
    $totalStmt = $pdo->prepare($totalQuery);
    $totalStmt->execute([':institute_id' => $institute_id]);
    $recordsTotal = $totalStmt->fetchColumn();

    // Filtered records
    $filteredQuery = "
        SELECT COUNT(*) 
        FROM quiz_master qm 
        $whereClause
    ";
    $filteredStmt = $pdo->prepare($filteredQuery);
    $filteredStmt->execute($params);
    $recordsFiltered = $filteredStmt->fetchColumn();

    // If course_id is provided, join course_quiz to get assigned module_id per quiz
    if ($course_id) {
        $dataQuery = "
            SELECT 
                qm.quiz_id,
                qm.quiz_title,
                qm.is_block,
                cq.module_id
            FROM quiz_master qm
            LEFT JOIN course_quiz cq ON cq.quiz_id = qm.quiz_id AND cq.course_id = :course_id
            $whereClause
            ORDER BY $sortField $sortDir
            LIMIT :start, :length
        ";
        $params[':course_id'] = $course_id;
    } else {
        // Without course_id, no join and no module_id
        $dataQuery = "
            SELECT 
                qm.quiz_id,
                qm.quiz_title,
                qm.is_block
            FROM quiz_master qm
            $whereClause
            ORDER BY $sortField $sortDir
            LIMIT :start, :length
        ";
    }

    $dataStmt = $pdo->prepare($dataQuery);

    foreach ($params as $key => $val) {
        if ($key === ':start' || $key === ':length') continue;
        $dataStmt->bindValue($key, $val);
    }
    $dataStmt->bindValue(':start', $start, PDO::PARAM_INT);
    $dataStmt->bindValue(':length', $length, PDO::PARAM_INT);

    $dataStmt->execute();
    $data = $dataStmt->fetchAll(PDO::FETCH_ASSOC);

    // Fetch assigned modules only if course_id provided
    $assignedModules = [];
    if ($course_id) {
        $assignedQuery = "SELECT DISTINCT module_id FROM course_quiz WHERE course_id = :course_id AND module_id IS NOT NULL";
        $assignedStmt = $pdo->prepare($assignedQuery);
        $assignedStmt->execute([':course_id' => $course_id]);
        $assignedModules = $assignedStmt->fetchAll(PDO::FETCH_COLUMN);
    }

    echo json_encode([
        'draw' => intval($draw),
        'recordsTotal' => intval($recordsTotal),
        'recordsFiltered' => intval($recordsFiltered),
        'data' => $data,
        'assignedModules' => $assignedModules
    ]);

} catch (Exception $e) {
    echo json_encode(['error' => true, 'message' => $e->getMessage()]);
}