function loadExistingSubmodules() {
  $.ajax({
    url: './cr/get_submodules_api.php',
    type: 'POST',
    data: { course_id: course_id },
    dataType: 'json',
    success: function (data) {
      const list = $('#existingSubmodulesList');
      list.empty();

      if (data.status !== 'success' || !Array.isArray(data.data)) {
        list.append('<li class="list-group-item text-danger">Invalid response format</li>');
        return;
      }

      const addedSubmoduleIds = new Set();
      $('#newSubmodulessmcontainer .card').each(function () {
        const id = $(this).attr('id');
        const match = id && id.match(/^submodule_(\d+)$/);
        if (match) addedSubmoduleIds.add(match[1]);
      });

      data.data.forEach(function (mod) {
        const isChecked = mod.is_selected == 1 ? 'checked' : '';
        const li = `
          <li class="list-group-item">
            <div class="form-check d-flex align-items-center" style="gap: 10px;">
              <input type="checkbox" class="form-check-input" value="${mod.submodule_id}" data-submodule-name="${mod.submodule_name}" ${isChecked} />
              <label class="form-check-label mb-0" style="cursor: pointer;">
                ${mod.submodule_name}
              </label>
            </div>
          </li>`;

        list.append(li);
      });
    },
    error: function () {
      $('#existingSubmodulesList').html('<li class="list-group-item text-danger">Failed to load submodules.</li>');
    }
  });
}

function refreshSubmodulesUI(courseId) {
  $.ajax({
    url: './cr/get_initial_data.php',
    method: 'GET',
    data: { course_id: courseId },
    dataType: 'json',
    success: function (res) {
      if (res.status === 'success') {
        $('#submoduleTableBody').empty();
        $('#newSubmodulessmcontainer').empty();
        renderSubmoduleCards(res.data);
        renderSubmoduleTable(res.data);
      }
    }
  });
}

window.onload = function () {
  refreshSubmodulesUI(course_id);

  $('#existingSubmodulesModal').on('shown.bs.modal', function () {
    loadExistingSubmodules();
  });

  let submoduleCounter = 1;

  window.addNewSubmodule = function () {
    const submoduleId = `newSubmodule${submoduleCounter++}`;
    const smcontainer = document.getElementById('newSubmodulessmcontainer');

    const card = document.createElement('div');
    card.className = 'box box-default-submodule';
    card.id = submoduleId;
    card.innerHTML = `
      <div class="box-body">
        <div class="row mb-2 mt-25">

        <div class="col-md-6">
            <input type="text" id="${submoduleId}-title" class="form-control me-2" placeholder="Enter Submodule Name" />
        </div>
 
 
        <div class="col-md-6">
            <button class="btn btn-primary" onclick="submitStudiesSubModule('${submoduleId}', 0)">Add Submodule</button>

        <a class="btn btn-sm btn-danger" href="javascript:void(0);" onclick="document.getElementById('${submoduleId}').remove();" title="Remove Submodule"><i class="fa fa-minus"></i></a>
        
                          
        </div>
    
        </div>
        
        <div class="study-rows-submodule" id="${submoduleId}-study-rows-submodule"></div>
        <button class="btn btn-secondary btn-sm mt-25" onclick="addStudyRowSubmodule('${submoduleId}')">+ Add Study</button>
        
      </div>
    `;
    smcontainer.appendChild(card);
  };

  window.submitStudiesSubModule = function (submoduleDomId, submoduleDbId) {
    const titleInput = document.getElementById(`${submoduleDomId}-title`);
    const title = titleInput.value.trim();

    if (!title) {
      alert("Please enter a submodule name.");
      return;
    }

    $.ajax({
      type: "POST",
      url: "./cr/add_submodule_and_assign_api.php",
      data: { submodule_name: title, course_id: course_id},
      dataType: "json",
      success: function (res) {
        if (res.status === "success") {
          //alert("Submodule added successfully.");

    const card = document.getElementById(submoduleDomId);
    card.setAttribute("data-submodule-db-id", res.submodule_id);        
          refreshSubmodulesUI(course_id);
        } else {
          alert("Failed to add submodule.");
        }
      },
      error: function () {
        alert("AJAX error occurred.");
      }
    });
  };

  window.addStudyRowSubmodule = function (submoduleId) {
    const smcontainer = document.getElementById(`${submoduleId}-study-rows-submodule`);
    if (!smcontainer) {
      console.error(`Missing study row smcontainer for submoduleId: ${submoduleId}`);
      return;
    }
    const row = document.createElement("div");
    row.className = "study-row-submodule row mb-2 mt-25";
    row.innerHTML = `
      <div class="col-md-6">
        <input type="text" class="form-control study-title" placeholder="Study Title" />
      </div>
      <div class="col-md-4">
        <input type="file" class="form-control study-file" />
      </div>
      <div class="col-md-1">
        <button class="btn btn-sm" style="background: #5D2B8B;color:#fff;" onclick="uploadSingleStudySubmodule(this, '${submoduleId}')">Upload</button>
        <span class="upload-status ms-2"></span>
      </div>
      <div class="col-md-1">
      <a href="javascript:void(0);" onclick="this.closest('.study-row-submodule').remove()">
        <img src="images/delete.svg" title="Delete Study Material">
      </a>
      </div>
    `;
    smcontainer.appendChild(row);
  };

  window.uploadSingleStudySubmodule = function (btn, submoduleDomId) {
    const row = btn.closest('.study-row-submodule');
    const titleInput = row.querySelector(".study-title");
    const fileInput = row.querySelector(".study-file");
    const statusSpan = row.querySelector(".upload-status");

    const title = titleInput.value.trim();
    const file = fileInput.files[0];

    if (!title || !file) {
      alert("Please provide both title and file.");
      return;
    }

    const submoduleDbId = getSubmoduleDbIdFromDomId(submoduleDomId);
    if (!submoduleDbId) {
      alert("Submodule ID not found. Please save the submodule first.");
      return;
    }

    const formData = new FormData();
    formData.append("action", "upload_single_study");
    formData.append("module_id", moduleDbId);
    formData.append("title", title);
    formData.append("file", file);

    statusSpan.textContent = "⏳ Uploading...";

    $.ajax({
      url: "./cr/upload_file.php",
      method: "POST",
      data: formData,
      processData: false,
      contentType: false,
      success: function (res) {
        if (res.status === "success") {
          
          if (res.video_id) {
            row.setAttribute("data-video-id-sub", res.video_id);
          }
          
           refreshSubmodulesUI(course_id);
        } else {
          statusSpan.textContent = "❌ Failed";
        }
      },
      error: function () {
        statusSpan.textContent = "❌ Error";
      },
    });
  };

function getsubmoduleDbIdFromDomId(submoduleDomId) {
  const card = document.getElementById(submoduleDomId);
  if (!card) return null;

  const submoduleDbId = card.getAttribute("data-submodule-db-id");
  return submoduleDbId ? parseInt(submoduleDbId) : null;
}


  window.addSelectedSubmodules = function () {
    const selected = $('#existingSubmodulesList input:checked');
    if (selected.length === 0) {
      alert('Please select at least one submodule.');
      return;
    }

    const submoduleIds = [];
    const submoduleNames = {};

    selected.each(function () {
      const submoduleId = $(this).val();
      const submoduleName = $(this).data('submodule-name');
      submoduleIds.push(submoduleId);
      submoduleNames[submoduleId] = submoduleName;
    });

    $.ajax({
      url: './cr/add_course_submodule_api.php',
      type: 'POST',
      data: JSON.stringify({ submodule_ids: submoduleIds, course_id: course_id }),
      contentType: 'application/json',
      success: function (response) {
        if (response.status === 'success') {
          refreshSubmodulesUI(course_id);
          alert(response.message);
        } else {
          alert(response.message || 'Something went wrong!');
        }
      },
      error: function (xhr) {
        console.error(xhr.responseText);
        alert('Error contacting API.');
      }
    });
  };

  window.deleteVideoFromVimeoSubmodule = function (btn) {
    const row = btn.closest('.study-row-submodule');
    const videoId = row.getAttribute('data-video-id-sub');

    if (!videoId) {
      row.remove();
      return;
    }

    if (!confirm("Are you sure you want to delete this video from Vimeo?")) return;

    $.ajax({
      url: './cr/delete_vimeo_video.php',
      type: 'POST',
      data: { video_id: videoId },
      dataType: 'json',
      success: function (response) {
        if (response.success) {
          row.remove();
          alert('Video deleted successfully.');
        } else {
          alert('Failed to delete video: ' + response.message);
        }
      },
      error: function (xhr, status, error) {
        alert('AJAX error: ' + error);
      }
    });
  };
};

function renderSubmoduleTable(submodules) {
  submodules.forEach((submodule, index) => {
    const studyCount = submodule.study_materials ? submodule.study_materials.length : 0;
    const row = `
      <tr>
        <td>${index + 1}</td>
        <td>${submodule.submodule_name}</td>
        <td>${studyCount}</td>
      </tr>`;
    $('#submoduleTableBody').append(row);
  });
}

function renderSubmoduleCards(submodules) {
  submodules.forEach(submodule => {
    const submoduleId = submodule.submodule_id;
    const submoduleName = submodule.submodule_name;
    const studyMaterials = submodule.study_materials || [];
    const uniqueId = 'card_' + submoduleId + '_' + Date.now();

    let studyRowsHTMLSM = `
      <div class="box box-default-submodule" id="${uniqueId}" data-submodule-db-id="${submoduleId}">
        <div class="box-header with-border">
          <h3 class="box-title-course">Submodule Name - ${submoduleName}</h3>
          <div class="box-tools pull-right">
            <button class="btn btn-sm btn-danger remove-submodule-btn" data-submodule-id="${submoduleId}" style="margin-top: 3px;" data-smcard-id="${uniqueId}">Remove</button>
          </div>
        </div>
        <div class="box-body">
          <div class="study-rows-submodule" id="${uniqueId}-study-rows-submodule">
    `;

    studyMaterials.forEach(material => {
      const title = material.title || '';
      const fileName = material.actual_file_name || '';
      const vimeoLink = material.vimeo_link || '#';
      const videoId = material.study_material_id;

      studyRowsHTMLSM += `
        <div class="study-row-submodule row mb-2 mt-25" data-video-id-sub="${videoId}">
          <div class="col-md-6">
            <input type="text" class="form-control study-title" value="${title}" readonly>
          </div>
          <div class="col-md-4 selected-file">
            <a href="${vimeoLink}" target="_blank">${fileName}</a>
          </div>
          <div class="col-md-1">
            <button class="btn btn-sm" style="background: #5D2B8B;color:#fff;" onclick="uploadSingleStudySubmodule(this, '${uniqueId}')">Upload</button>
            <span class="upload-status ms-2"></span>
          </div>
          <div class="col-md-1">
          <a href="javascript:void(0);" onclick="deleteVideoFromVimeoSubmodule(this)">
              <img src="images/delete.svg" title="Delete Study Material" />
          </a>
          </div>
        </div>
      `;
    });

    studyRowsHTMLSM += `
          </div>
          <div class="row mt-2 mt-25">
            <div class="col-md-7">
              <button class="btn btn-secondary btn-sm mb-2" onclick="addStudyRowSubmodule('${uniqueId}')">+ Add Study</button>
            </div>
          </div>
        </div>
      </div>
    `;

    $('#newSubmodulessmcontainer').append(studyRowsHTMLSM);
  });
}

$(document).on('click', '.remove-submodule-btn', function () {
  const submoduleId = $(this).data('submodule-id');
  const cardId = $(this).data('smcard-id');

  if (!confirm("Are you sure you want to remove this submodule?")) return;

  $.ajax({
    url: './cr/delete_course_submodule_api.php',
    method: 'POST',
    data: { submodule_id: submoduleId, course_id: course_id },
    dataType: 'json',
    success: function (response) {
      if (response.status === 'success') {
        document.getElementById(cardId)?.remove();
        loadExistingSubmodules();
        refreshSubmodulesUI(course_id);
        alert('Submodule removed successfully.');
      }
    },
    error: function () {
      alert('AJAX error occurred while deleting.');
    }
  });
});