<?php
require_once('../includes/connection.php');
header('Content-Type: application/json');

// Read JSON input
$input = json_decode(file_get_contents('php://input'), true);

// Validate input
if (!isset($input['course_id']) || !isset($input['modules']) || !is_array($input['modules'])) {
    echo json_encode(['status' => 'error', 'message' => 'Invalid input.']);
    exit;
}

$course_id = $input['course_id'];
$modules = $input['modules'];

try {
    $stmt = $pdo->prepare("UPDATE course_module SET sequence = :sequence WHERE module_id = :module_id AND course_id = :course_id");

    foreach ($modules as $module) {
        if (isset($module['module_id']) && isset($module['sequence'])) {
            $stmt->execute([
                ':sequence'   => $module['sequence'],
                ':module_id'  => $module['module_id'],
                ':course_id'  => $course_id
            ]);
        }
    }

    echo json_encode(['status' => 'success']);
} catch (PDOException $e) {
    error_log("Module sequence update error: " . $e->getMessage());
    echo json_encode(['status' => 'error', 'message' => 'Update failed.']);
}