<?php
require_once('../includes/connection.php');
header('Content-Type: application/json');

// Read JSON input
$input = json_decode(file_get_contents('php://input'), true);

// Validate input
if (!isset($input['course_id']) || !isset($input['submodules']) || !is_array($input['submodules'])) {
    echo json_encode(['status' => 'error', 'message' => 'Invalid input.']);
    exit;
}

$course_id = $input['course_id'];
$submodules = $input['submodules'];

try {
    $stmt = $pdo->prepare("UPDATE course_submodule SET sequence = :sequence WHERE submodule_id = :submodule_id AND module_id = :module_id AND course_id = :course_id");

    foreach ($submodules as $submodule) {
        if (isset($submodule['submodule_id']) && isset($submodule['sequence'])) {
            $stmt->execute([
                ':sequence'   => $submodule['sequence'],
                ':submodule_id'  => $submodule['submodule_id'],
                'module_id' => $submodules['module_id'],
                ':course_id'  => $course_id
            ]);
        }
    }

    echo json_encode(['status' => 'success']);
} catch (PDOException $e) {
    error_log("Module sequence update error: " . $e->getMessage());
    echo json_encode(['status' => 'error', 'message' => 'Update failed.']);
}