<?php
require_once('../includes/connection.php');
require('../vendor/autoload.php');

use Vimeo\Vimeo;

function uploadStudyMaterial($file, $title)
{
    $clientId = "33aca9a43d56881867d184a6fd6812214c859d7f";
    $clientSecret = "RxhsebeBUpDtexh1NEy/wtvc6nygztKCQuLdumBH9brJxhYccpNdUDs2dbrBJgi8ERWF+5ey2jShRKRt5+zboo9Euza+5XIkgfnKhBSPEk0o9dT4W8FEZmUuKEl6td4b";
    $accessToken = "75e5b3cf9fecae07f07f254889398e20";

    $projectId = '27758751'; // question_videos folder
    $userId = '239261674';  // Your Vimeo user ID

    if ($file['error'] !== UPLOAD_ERR_OK) {
        return ['success' => false, 'message' => 'File upload error'];
    }

    $fileTmp = $file['tmp_name'];
    $ext = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));

    $allowedExt = ['mp4', 'mov', 'avi', 'mkv'];
    if (!in_array($ext, $allowedExt)) {
        return ['success' => false, 'message' => 'Invalid video format'];
    }

    $client = new Vimeo($clientId, $clientSecret, $accessToken);

    try {
        // 🔹 Upload video
        $uri = $client->upload($fileTmp, [
            'name' => $title,
        ]);

        // 🔹 Get video ID
        $videoId = str_replace('/videos/', '', $uri);

        // 🔹 Move to folder (project)
        $move = $client->request(
            "/me/projects/{$projectId}/videos/{$videoId}",
            [],
            'PUT'
        );

        if ($move['status'] !== 204) {
            error_log("Failed to move video to folder");
        }

        // 🔹 Get video link
        $video = $client->request($uri);
        $videoLink = $video['body']['link'];

        return [
            'success'    => true,
            'video_id'   => $videoId,
            'video_link' => $videoLink,
        ];

    } catch (Exception $e) {
        return [
            'success' => false,
            'message' => $e->getMessage()
        ];
    }
}