<?php 
$page_name = 'Edit Course';

require_once('includes/connection.php');
require_once('includes/header.php');
?>

  <div class="content-wrapper">
    <section class="content-header">
      <span class="p-10">
        Edit COURSE
      </span>
      <ol class="breadcrumb">
        <li><a href="masters.php"> Masters</a></li>
        <li><a href="course_master.php">Course</a></li>
        <li class="active">Edit Course</li>
      </ol>
    </section>
    
    
    <section class="content">
      <div class="box box-default">
        <div class="box-header with-border">
          <p class="box-title">*All fields are required</p>
            <div class="col-md-4 response-msg" id="responseMessage">
            </div>  
        </div>

            <form id="courseForm">
                <div class="box-body">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Course Name</label>
                                <input class="form-control" type="text" autocomplete="off" id="course_name" name="course_name" required>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Course Category</label>
                                <select class="form-control select21" id="course_category" name="course_category" data-placeholder="Select Category"
                                        style="width: 100%;">
                                    <!-- Options will be populated dynamically -->
                                </select>
                            </div>
                        </div> 
                        
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Level</label>
                                <select class="form-control select21" id="level" name="level" data-placeholder="Select Level"
                                        style="width: 100%;">
                                    <option value="1">Level 1</option>
                                    <option value="2">Level 2</option>
                                    <option value="3">Level 3</option>
                                </select>
                            </div>
                        </div>                         
                        
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>No Of Installments</label>
                                <input class="form-control" type="text" autocomplete="off" id="no_of_installments" name="no_of_installments" required>
                            </div>
                        </div>
                        
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>No Of Documents</label>
                                <input class="form-control" type="text" autocomplete="off" id="no_of_documents" name="no_of_documents" required>
                            </div>
                        </div>
                        
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>No Of Hours (In Mins)</label>
                                <input class="form-control" type="text" autocomplete="off" id="no_of_hours" name="no_of_hours" required>
                            </div>
                        </div>
                        
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>No Of Assesments</label>
                                <input class="form-control" type="text" autocomplete="off" id="no_of_assesments" name="no_of_assesments" required>
                            </div>
                        </div> 
                        
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>No Of Quizes</label>
                                <input class="form-control" type="text" autocomplete="off" id="no_of_quizes" name="no_of_quizes" required>
                            </div>
                        </div>   

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Course Fees</label>
                                <input class="form-control" type="text" autocomplete="off" id="course_fees" name="course_fees" required>
                            </div>
                        </div>      
                                                
                        
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Course Start Date</label>
                                <input class="form-control" type="date" autocomplete="off" id="course_start_date" name="course_start_date" required>
                            </div>
                        </div>
                        

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Course End Date</label>
                                <input class="form-control" type="date" autocomplete="off" id="course_end_date" name="course_end_date" required>
                            </div>
                        </div>
 
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Course Mentrors</label>
                                <select class="form-control select2" multiple="multiple" id="course_mentors" name="course_mentors" data-placeholder="Select Mentors"
                                        style="width: 100%;">
                                    <!-- Options will be populated dynamically -->
                                </select>
                            </div>
                        </div>
                        
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Language</label>
                                <select class="form-control select21" id="language" name="language" data-placeholder="Select Language"
                                        style="width: 100%;">
                                    <option value="english">English</option>
                                    <option value="marathi">Marathi</option>
                                    <option value="hindi">Hindi</option>
                                </select>
                            </div>
                        </div> 
                        
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Keywords</label>
                                <input class="form-control" type="text" autocomplete="off" id="keywords" name="keywords" required>
                            </div>
                        </div>
                        
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Outcomes</label>
                                <textarea class="form-control" type="text" autocomplete="off" id="outcomes" name="outcomes"></textarea>
                            </div>
                        </div>                          
                        
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Description</label>
                                <textarea class="form-control" type="text" autocomplete="off" id="description" name="description"></textarea>
                            </div>
                        </div>
        
                        
                    </div>
                
                
                    <div class="box-footer">
                        <button type="submit" class="btn btn-primary">Update</button>
                        <a href="course_master.php"  class="btn btn-secondary"> Back</a>
                    </div>
                </div>
            </form>
      </div>
    </section>
  </div>


<?php require_once('includes/footer.php'); ?>

<script>
$(document).ready(function () {
    // Fetch Categories
    $.ajax({
        url: 'apis/category_api.php',
        type: 'GET',
        dataType: 'json',
        success: function (data) {
            if (Array.isArray(data)) {
                let options = '';
                data.forEach(function (role) {
                    options += `<option value="${role.category_id}">${role.category_name}</option>`;
                });

                // Populate category select element
                const categorySelect = $('#course_category');
                categorySelect.html(options);
                
                // Refresh Select2 dropdown after population
                categorySelect.trigger('change');
            } else {
                console.error('Error: Invalid response format', data);
            }
        },
        error: function (xhr, status, error) {
            console.error('Error occurred while fetching data:', error);
        }
    });

    // Fetch Mentors
    $.ajax({
        url: 'apis/mentor_api.php',
        type: 'GET',
        dataType: 'json',
        success: function (data) {
            if (Array.isArray(data)) {
                let options = '';
                data.forEach(function (mentor) {
                    options += `<option value="${mentor.mentor_id}">${mentor.mentor_name}</option>`;
                });

                // Populate mentor select element
                const mentorSelect = $('#course_mentors');
                mentorSelect.html(options);
                
                // Refresh Select2 dropdown after population
                mentorSelect.trigger('change');
            } else {
                console.error('Error: Invalid response format', data);
            }
        },
        error: function (xhr, status, error) {
            console.error('Error occurred while fetching data:', error);
        }
    });

    // Handle form submission
    $('#courseForm').on('submit', function (event) {
        event.preventDefault();

        // Collect form data
        var formData = {
            'course_name': $('#course_name').val(),
            'course_category': $('#course_category').val(),
            'level': $('#level').val(),
            'no_of_installments': $('#no_of_installments').val(),
            'no_of_documents': $('#no_of_documents').val(),
            'no_of_hours': $('#no_of_hours').val(),
            'no_of_assesments': $('#no_of_assesments').val(),
            'no_of_quizes': $('#no_of_quizes').val(),
            'course_fees': $('#course_fees').val(),
            'course_start_date': $('#course_start_date').val(),
            'course_end_date': $('#course_end_date').val(),
            'course_mentors': $('#course_mentors').val(),
            'language': $('#language').val(),
            'keywords': $('#keywords').val(),
            'description': $('#description').val(),
            'outcomes': $('#outcomes').val()
        };


        // Submit the form data
        $.ajax({
            url: 'apis/edit_course_api.php',
            method: 'POST',
            contentType: 'application/json',
            data: JSON.stringify({
                data: formData
            }),
            success: function (data) {
                if (data.status === 'success') {
                    showAlert(data.message, 'success');
                    $('#courseForm')[0].reset(); // Reset the form
                    $('#course_mentors').val(null).trigger('change'); // Reset mentor dropdown
                } else {
                    showAlert(data.message, 'danger');
                }
            },
            error: function (error) {
                console.error('Error:', error);
                showAlert('An error occurred while processing your request.', 'danger');
            }
        });
    
    });
    
            
    const urlParams = new URLSearchParams(window.location.search);
    const employeeId = urlParams.get('id');

    if (employeeId) {
        prepopulateCourseForm(employeeId);
    }
    
});
</script>

</body>
</html>