<?php 
$page_name = 'Edit Course';

require_once('includes/connection.php');
require_once('includes/header.php');

?>

  <div class="content-wrapper">
    <section class="content-header">
      <span class="p-10">
        EDIT NEW COURSE
      </span>
      <ol class="breadcrumb">
        <li><a href="masters.php"> Masters</a></li>
        <li><a href="course_master.php">Course</a></li>
        <li class="active">Edit Course</li>
      </ol>
    </section>
    
    
    <section class="content">
      <div class="box box-default">
        <div class="box-header with-border">
          <p class="box-title">* All fields marked with an asterisk are required</p>
            <div class="col-md-4 response-msg" id="responseMessage">
            </div>  
        </div>

            <form id="courseForm">
    <div class="box-body">
        <div class="row">

            <div class="col-md-4">
                <div class="form-group">
                    <label>Course Name <span class="text-danger">*</span></label>
                    <input class="form-control" type="text" autocomplete="off" id="course_name" name="course_name" required>
                </div>
            </div>

            <div class="col-md-4">
                <div class="form-group">
                    <label>Course Category <span class="text-danger">*</span></label>
                    <select class="form-control select2" id="course_category" name="course_category" data-placeholder="Select Category"
                            style="width: 100%;" required>
                        <!-- Options will be populated dynamically -->
                    </select>
                </div>
            </div> 
            
            <div class="col-md-4">
                <div class="form-group">
                    <label>Level <span class="text-danger">*</span></label>
                    <select class="form-control select2" id="level" name="level" data-placeholder="Select Level"
                            style="width: 100%;" required>
                        <option value="1">Level 1</option>
                        <option value="2">Level 2</option>
                        <option value="3">Level 3</option>
                    </select>
                </div>
            </div>    

            <div class="col-md-4">
                <div class="form-group">
                    <label>Course Image</label>
                    <input class="form-control" type="file" autocomplete="off" id="course_img" name="course_img" accept="image/png, image/gif, image/jpeg">
                    <br>
                    <!-- Image Preview -->
                    <img id="course_img_preview" src="#" alt="No Image" style="max-height:100px; display:none; border:1px solid #ddd; padding:5px;">
                </div>
            </div>                        
            
            <div class="col-md-4">
                <div class="form-group">
                    <label>Description</label>
                    <textarea class="form-control" type="text" autocomplete="off" id="description" name="description"></textarea>
                </div>
            </div>

        </div>

        <div class="box-footer">
            <button type="submit" class="btn btn-primary">Submit</button>
            <a href="course_master.php" class="btn btn-secondary">Back</a>
        </div>
    </div>
</form>

      </div>
    </section>
  </div>


<?php require_once('includes/footer.php'); ?>

<script>
$(document).ready(function () {

    // Fetch Categories
    $.ajax({
        url: 'apis/category_api.php',
        type: 'GET',
        dataType: 'json',
        success: function (data) {
            if (Array.isArray(data)) {
                let options = '';
                data.forEach(function (role) {
                    options += `<option value="${role.category_id}">${role.category_name}</option>`;
                });
                const categorySelect = $('#course_category');
                categorySelect.html(options);
                categorySelect.trigger('change');
            } else {
                console.error('Error: Invalid response format', data);
            }
        },
        error: function (xhr, status, error) {
            console.error('Error occurred while fetching data:', error);
        }
    });

    // Handle form submission
    $('#courseForm').on('submit', function (event) {
    event.preventDefault();

    const urlParams = new URLSearchParams(window.location.search);
    const courseId = urlParams.get('id');

    if (!courseId) {
        alert('No Course ID found in the URL!');
        return;
    }

    var formData = new FormData();

    formData.append('course_name', $('#course_name').val());
    formData.append('course_category', $('#course_category').val());
    formData.append('level', $('#level').val());
    formData.append('description', $('#description').val());
    formData.append('course_id', courseId);

    var courseImg = $('#course_img')[0].files[0];

    if (courseImg) {
        if (courseImg.size > 1048576) {
            // If file size is more than 1MB, show an error message
            showAlert('File size exceeds the 1MB limit.', 'danger');
            return;
        } else {
            formData.append('course_img', courseImg);
        }
    }
    
    $.ajax({
        url: 'apis/edit_course_api.php',
        method: 'POST',
        processData: false,
        contentType: false,
        data: formData,
        success: function (data) {
            if (data.status === 'success') {
                showAlert(data.message, 'success');
            } else {
                showAlert(data.message, 'danger');
            }
        },
        error: function (xhr, status, error) {
            console.error('Error:', error);
            showAlert('An error occurred while submitting the form.', 'danger');
        }
    });
});
    

    const urlParams = new URLSearchParams(window.location.search);
    const courseId = urlParams.get('id');

    if (courseId) {
        prepopulateCourseForm(courseId);
    }
});

</script>

</body>
</html>