<?php 
$page_name = 'Edit FAQ';

require_once('includes/connection.php');
require_once('includes/header.php');

?>

  <div class="content-wrapper">
    <section class="content-header">
      <span class="p-10">
        EDIT FAQ
      </span>
      <ol class="breadcrumb">
        <li><a href="masters.php"> Masters</a></li>
        <li><a href="faq_master.php">FAQ</a></li>
        <li class="active">Edit FAQ</li>
      </ol>
    </section>
    
    
    <section class="content">
      <div class="box box-default">
        <div class="box-header with-border">
          <p class="box-title">* All fields marked with an asterisk are required</p>
            <div class="col-md-4 response-msg" id="responseMessage">
            </div>  
        </div>

            <form id="faqForm">
    <div class="box-body">
        <div class="row">
            <div class="col-md-4">
                <div class="form-group">
                    <label>FAQ Question <span class="text-danger">*</span></label>
                    <textarea class="form-control" autocomplete="off" id="faq_question" name="faq_question" required></textarea>
                </div>
            </div>

            <div class="col-md-4">
                <div class="form-group">
                    <label>FAQ Answer <span class="text-danger">*</span></label>
                    <textarea class="form-control" autocomplete="off" id="faq_answer" name="faq_answer" required></textarea>
                </div>
            </div>

            <div class="col-md-4">
                <div class="form-group">
                    
                    <div class="radio">
                        <input name="faq_block" value="1" type="radio" id="BlockFAQ" class="with-gap radio-col-red">
                        <label for="BlockFAQ">Block FAQ</label>                    
                    </div>
                    <div class="radio">
                        <input name="faq_block" value="0" type="radio" id="UnblockFAQ" class="with-gap radio-col-red" checked="">
                        <label for="UnblockFAQ">Unblock FAQ</label>   
                    </div>
                </div>
            </div>
        </div>
        
        <div class="box-footer">
            <button type="submit" class="btn btn-primary">Submit</button>
            <a href="faq_master.php" class="btn btn-secondary">Back</a>
        </div>
    </div>
</form>

      </div>
    </section>
  </div>

<?php require_once('includes/footer.php'); ?>

<script>
$('#faqForm').on('submit', function (event) {
    event.preventDefault();

    const urlParams = new URLSearchParams(window.location.search);
    const faqId = atob(urlParams.get('id'));  // Decode Base64 ID

    if (!faqId) {
        alert('No FAQ ID found in the URL!');
        return;
    }

    var formData = {
        faq_id: faqId,  // Send decoded ID
        faq_question: $('#faq_question').val(),
        faq_answer: $('#faq_answer').val(),
        faq_block: $('input[name="faq_block"]:checked').val()  
    };


    $.ajax({
        url: 'apis/edit_faq_api.php',
        method: 'POST',
        contentType: 'application/json',
        data: JSON.stringify(formData),
        success: function (data) {
            console.log("Server Response:", data);
            if (data.status === 'success') {
                showAlert(data.message, 'success');
            } else {
                showAlert(data.message, 'danger');
            }
        },
        error: function (xhr, status, error) {
            console.error('Error:', error);
            showAlert('An error occurred while submitting the form.', 'danger');
        }
    });
});




const urlParams = new URLSearchParams(window.location.search);
const faqId = urlParams.get('id');

if (faqId) {
    prepopulateFaqForm(faqId);  
}
</script>

</body>
</html>