<?php
$page_name = 'Edit Submodule';

require_once('includes/connection.php');
require_once('includes/header.php'); // Assumed to include jQuery and other necessary libraries
?>

<div class="content-wrapper">
    <section class="content-header">
        <span class="p-10">
            EDIT SUBMODULE
        </span>
        <ol class="breadcrumb">
            <li><a href="masters.php"> Masters</a></li>
            <li><a href="submodule_master.php">Submodule</a></li>
            <li class="active">Edit Submodule</li>
        </ol>
    </section>

    <section class="content">
        <div class="box box-default">
            <div class="box-header with-border">
                <p class="box-title">* All fields marked with an asterisk are required</p>
                <div class="col-md-4 response-msg" id="responseMessage">
                </div>
            </div>

            <form id="submoduleForm">
                <div class="box-body">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Submodule Name <span class="text-danger">*</span></label>
                                <input class="form-control" type="text" autocomplete="off" id="submodule_name" name="submodule_name" required>
                            </div>
                        </div>
                        <!--<div class="col-md-3">-->
                        <!--    <div class="form-group">-->
                        <!--        <label>Module Name <span class="text-danger">*</span></label>-->
                        <!--        <select class="form-control select2 module-select" id="module_id_select" name="module_id" style="width: 100%;"></select>-->
                        <!--    </div>-->
                        <!--</div>-->
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Description (Optional)</label>
                                <textarea class="form-control" type="text" autocomplete="off" id="description" name="description"></textarea>
                            </div>
                        </div>
                        <input type="hidden" id="submodule_id_hidden" name="submodule_id">
                    </div>

                    <div class="box-footer">
                        <button type="submit" class="btn btn-primary">Update</button>
                        <a href="submodule_master.php" class="btn btn-secondary"> Back</a>
                    </div>
                </div>
            </form>
        </div>
    </section>
</div>

<?php require_once('includes/footer.php'); ?>

<script>

$(document).ready(function() {

    // Function to populate a specific module dropdown element
    function populateModuleDropdown(dropdownElement, selectedModuleId = null) {
        $.ajax({
            url: 'apis/module_api.php', // API endpoint to get all modules
            method: 'GET',
            dataType: 'json',
            success: function(response) {
                dropdownElement.empty().append('<option value="">Select Module</option>');

                if (Array.isArray(response)) {
                    if (response.length === 0) {
                        dropdownElement.append('<option value="" disabled>No modules found.</option>');
                    } else {
                        response.forEach(function (moduleItem) {
                            dropdownElement.append(`<option value="${moduleItem.module_id}">${moduleItem.module_name}</option>`);
                        });
                    }
                } else {
                    dropdownElement.append('<option value="" disabled>Error loading modules: Unexpected response format.</option>');
                    console.warn("API returned an unexpected non-array structure:", response);
                }

                // Pre-select the module if selectedModuleId is provided
                if (selectedModuleId) {
                    dropdownElement.val(selectedModuleId);
                    // If using Select2, trigger change event to update its display
                    // dropdownElement.trigger('change.select2'); // Uncomment if you are using Select2
                }
                // Initialize Select2 if you are using it (and it hasn't been initialized yet)
                // if (!dropdownElement.data('select2')) { // Uncomment if you are using Select2
                //     dropdownElement.select2(); // Uncomment if you are using Select2
                // }
            },
            error: function(jqXHR, textStatus, errorThrown) {
                console.error("Error fetching modules:", textStatus, errorThrown, jqXHR.responseText);
                dropdownElement.empty().append('<option value="" disabled>Failed to load modules. Please check console for details.</option>');
                if (typeof showAlert === 'function') {
                    showAlert('Failed to load modules. Please check console for details.', 'danger');
                }
            }
        });
    }

    // Function to pre-populate the form with existing submodule data
    function prepopulateForm(submoduleId) {
        $.ajax({
            url: `apis/get_submodule_single_api.php?id=${submoduleId}`, // API endpoint to get single submodule details
            method: 'GET',
            dataType: 'json', // Ensure jQuery expects JSON response
            success: function(data) {
                if (data.status === 'success' && data.submodule) {
                    const submodule = data.submodule;
                    $('#submodule_name').val(submodule.submodule_name);
                    $('#description').val(submodule.description);
                    $('#submodule_id_hidden').val(submoduleId); // Store the original (encoded) ID

                    // Populate the module dropdown and then pre-select the correct module
                    populateModuleDropdown($('#module_id_select'), submodule.module_id);

                } else {
                    if (typeof showAlert === 'function') {
                        showAlert(data.message || 'Error fetching submodule data.', 'danger');
                    }
                    console.error('Error fetching submodule data:', data.message);
                }
            },
            error: function(jqXHR, textStatus, errorThrown) {
                console.error('Error:', textStatus, errorThrown, jqXHR.responseText);
                if (typeof showAlert === 'function') {
                    showAlert('An error occurred while fetching submodule data. Please try again.', 'danger');
                }
            }
        });
    }

    // Handle the form submission (for updating submodule)
    $('#submoduleForm').on('submit', function(event) {
        event.preventDefault();

        const submoduleId = $('#submodule_id_hidden').val(); // Get the (encoded) ID from hidden input
        const submoduleName = $('#submodule_name').val();
        const selectedModuleId = $('#module_id_select').val(); // Get selected module ID
        const description = $('#description').val();

        if (!submoduleId) {
            if (typeof showAlert === 'function') {
                showAlert('Error: Submodule ID is missing for update!', 'danger');
            }
            return;
        }
        //if (!submoduleName || !selectedModuleId) {
         if (!submoduleName) {
            if (typeof showAlert === 'function') {
                showAlert('Submodule Name and Module Name are required.', 'danger');
            }
            return;
        }

        const requestData = {
            submodule_id: submoduleId, // Send the encoded ID back
            submodule_name: submoduleName,
            module_id: selectedModuleId, // Include the selected module ID
            description: description,
        };

        // Send POST request to update submodule
        $.ajax({
            url: 'apis/edit_submodule_api.php',
            method: 'POST',
            contentType: 'application/json',
            data: JSON.stringify(requestData),
            success: function(data) {
                if (data.status === 'success') {
                    if (typeof showAlert === 'function') {
                        showAlert(data.message, 'success');
                    }
                    // Optionally redirect or refresh the list page after successful update
                    // window.location.href = 'submodule_master.php';
                } else {
                    if (typeof showAlert === 'function') {
                        showAlert(data.message, 'danger');
                    }
                }
            },
            error: function(jqXHR, textStatus, errorThrown) {
                console.error('Error updating submodule:', textStatus, errorThrown, jqXHR.responseText);
                if (typeof showAlert === 'function') {
                    showAlert('An error occurred during update. Please try again.', 'danger');
                }
            }
        });
    });

    // Initial load: Get submodule ID from URL and pre-populate form
    const urlParams = new URLSearchParams(window.location.search);
    const submoduleIdFromUrl = urlParams.get('id');

    if (submoduleIdFromUrl) {
        prepopulateForm(submoduleIdFromUrl);
    } else {
        // If no ID in URL, just populate the module dropdown (though this is an edit page)
        populateModuleDropdown($('#module_id_select'));
        if (typeof showAlert === 'function') {
            showAlert('No submodule ID found in URL. This page is for editing.', 'warning');
        }
    }
});
</script>

</body>
</html>