<?php 
$page_name = 'Employee Master';
require_once('includes/connection.php');
require_once('includes/header.php');
?>


<div class="content-wrapper">
  <section class="content-header">
    <span style="margin-left: 10px;">Employee Master</span>
    <a href="add_employee.php" style="float:right;" class="btn btn-primary">Add Employee</a>
  </section>

  <section class="content">
    <div class="box box-default">
      <div class="box-header with-border">
        <div class="col-md-4 response-msg-table" id="responseMessage"></div>
        <div class="box-body table-padding">

          <table id="dataGrid" class="table display">
            <thead style="background: #FAF7FE;">
              <tr>
                <th>Sr. No.</th>
                <th>Employee Name</th>
                <th>Phone No.</th>
                <th>Email ID</th>
                <th>Status</th>
                <th>Action</th>
              </tr>
            </thead>
          </table>

        </div>
      </div>
    </div>
  </section>
</div>


<?php require_once('includes/footer.php'); ?>

<script>

// ******** XSS SAFE ESCAPE FUNCTION ********
function escapeHtml(text) {
  return $('<div/>').text(text).html();
}

const sortState = {
  dir: 'desc',
  field: 'employee_id'
};

function deleteEmployee(encodedId) {
  const decodedId = parseInt(atob(encodedId));
  if (confirm('Are you sure you want to delete this employee?')) {
    fetch('apis/delete_employee_api.php', {
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      body: JSON.stringify({ employee_id: decodedId })
    })
    .then(res => res.json())
    .then(response => {
      if (response.status === 'success') {
        showAlert(response.message, 'success');
        dataTable.ajax.reload();
      } else {
        showAlert(response.message, 'danger');
      }
    })
    .catch(err => {
      console.error('Error:', err);
      alert('An error occurred while deleting.');
    });
  }
}

let dataTable;

const initDataTable = () => {
  dataTable = $('#dataGrid').DataTable({
    processing: true,
    serverSide: true,
    ordering: false,
    autoWidth: false,
    columnDefs: [
      { width: "70px", targets: 0 },
      { width: "300px", targets: 1 },
      { width: "150px", targets: 2 },
      { width: "200px", targets: 3 },
      { width: "100px", targets: 4 },
      { width: "100px", targets: 5 },
    ],
    language: { search: "Search:" },
    ajax: {
      url: 'apis/employee_api.php',
      type: 'POST',
      data: d => {
        d.sortField = sortState.field;
        d.sortDir = sortState.dir;
      },
      beforeSend: () => $('#page-loader').show(),
      complete: () => $('#page-loader').hide()
    },
    columns: [

      // Sr No
      {
        data: null,
        render: (d, t, r, meta) => meta.row + meta.settings._iDisplayStart + 1
      },

      // EMPLOYEE NAME (ESCAPED)
      {
        data: null,
        render: (data, type, row) => 
          `${escapeHtml(row.first_name)} ${escapeHtml(row.last_name)}`
      },

      // PHONE (ESCAPED)
      { 
        data: 'phone_no',
        render: data => escapeHtml(data)
      },

      // EMAIL (ESCAPED)
      { 
        data: 'email_id',
        render: data => escapeHtml(data)
      },

      // STATUS
      {
        data: 'is_block',
        render: data => data == '1'
          ? 'Inactive <span class="red-dot"></span>'
          : 'Active'
      },

      // ACTION BUTTONS (ESCAPED ID)
      {
        data: 'employee_id',
        orderable: false,
        searchable: false,
        render: id => {
          const encId = btoa(escapeHtml(id.toString()));
          return `
            <a href="view_employee.php?id=${encId}">
              <img src="images/view.svg" />
            </a>
            <a href="edit_employee.php?id=${encId}">
              <img src="images/edit.svg" />
            </a>
            <a href="javascript:void(0);" onclick="deleteEmployee('${encId}')">
              <img src="images/delete.svg" title="Delete Employee" />
            </a>
          `;
        }
      }
    ],

    initComplete: () => {
      const w = $('#dataGrid_filter input').outerWidth();
      const sortUI = `
        <label style="margin-left:10px;">
          Sort By:
          <select id="sortField" class="form-control input-sm" style="width:${w}px;">
            <option value="first_name">Employee Name</option>
            <option value="phone_no">Phone No.</option>
            <option value="email_id">Email ID</option>
            <option value="is_block">Status</option>
          </select>
          <span id="sortToggleIcon" title="Sort Descending" style="cursor:pointer;">
            ${sortState.dir === 'desc' ? '▼' : '▲'}
          </span>
        </label>
      `;
      $('#dataGrid_filter').append(sortUI);

      $('#sortField').val(sortState.field).select2({
        placeholder: "Select Field",
        containerCssClass: 'select2-table-sort'
      });

      $('#dataGrid_length select').select2({
        minimumResultsForSearch: Infinity,
        containerCssClass: 'select2-table-sort'
      });
    }
  });
};

$(document).ready(() => {
  initDataTable();

  $(document).on('change', '#sortField', function () {
    sortState.field = $(this).val();
    dataTable.ajax.reload();
  });

  $(document).on('click', '#sortToggleIcon', function () {
    sortState.dir = (sortState.dir === 'desc') ? 'asc' : 'desc';
    $(this).text(sortState.dir === 'desc' ? '▼' : '▲')
           .attr('title', `Sort ${sortState.dir === 'desc' ? 'Descending' : 'Ascending'}`);
    dataTable.ajax.reload();
  });
});
</script>

</body>
</html>