<script>

/* -----------------------------------------------
   GLOBAL ESCAPE FUNCTION (Prevents XSS)
----------------------------------------------- */
function escapeHtml(text) {
    return $('<div>').text(text).html();
}

/*****************************************************/

// Function to pre-populate the form for institute
function populateInstitutes(selectorId, selectedId = null) {
    $.ajax({
        url: './apis/institute_dropdown_api.php',
        method: 'GET',
        dataType: 'json',
        success: function(data) {
            if (data && Array.isArray(data.institutes)) {
                let options = '<option value="">Select Institute</option>';
                data.institutes.forEach(function(institute) {
                    const selectedAttr = selectedId == institute.id ? 'selected' : '';
                    const safeName = escapeHtml(institute.name);
                    options += `<option value="${institute.id}" ${selectedAttr}>${safeName}</option>`;
                });
                $(`#${selectorId}`).html(options).trigger('change');

            } else {
                console.error('Invalid response format from institute_api.php', data);
            }
        },
        error: function(xhr, status, error) {
            console.error('Failed to load institutes:', error);
        }
    });
}


function populateCourses(selectorId, selectedIds = []) {
    $.ajax({
        url: './apis/course_dropdown_api.php',
        type: 'GET',
        dataType: 'json',
        success: function(data) {
            if (data && Array.isArray(data.courses)) {
                let options = '<option value="">Select Course</option>';
                data.courses.forEach(function(course) {
                    const selectedAttr = selectedIds.includes(course.id.toString()) ? 'selected' : '';
                    const safeName = escapeHtml(course.name);
                    options += `<option value="${course.id}" ${selectedAttr}>${safeName}</option>`;
                });
                $(`#${selectorId}`).html(options).trigger('change');
            } else {
                console.error('Invalid course response format:', data);
            }
        },
        error: function(xhr, status, error) {
            console.error('Failed to load courses:', error);
        }
    });
}


function populateCountries(selectorId, selectedId = null) {
    $.ajax({
        url: './apis/country_dropdown_api.php',
        type: 'GET',
        dataType: 'json',
        success: function(data) {
            if (data && Array.isArray(data.countries)) {
                let options = '<option value="">Select Country</option>';
                data.countries.forEach(function(country) {
                    const selectedAttr = selectedId == country.id ? 'selected' : '';
                    const safeName = escapeHtml(country.name);
                    options += `<option value="${country.id}" ${selectedAttr}>${safeName}</option>`;
                });
                $(`#${selectorId}`).html(options).trigger('change');
            } else {
                console.error('Invalid response format from country_api.php', data);
            }
        },
        error: function(xhr, status, error) {
            console.error('Failed to load countries:', error);
        }
    });
}


function populateCategories(selectorId, selectedId = null) {
    $.ajax({
        url: './apis/category_dropdown_api.php',
        type: 'GET',
        dataType: 'json',
        success: function(data) {
            if (data && Array.isArray(data.categories)) {
                let options = '<option value="">Select Category</option>';
                data.categories.forEach(function(category) {
                    const selectedAttr = selectedId == category.id ? 'selected' : '';
                    const safeName = escapeHtml(category.name);
                    options += `<option value="${category.id}" ${selectedAttr}>${safeName}</option>`;
                });
                $(`#${selectorId}`).html(options).trigger('change');
            } else {
                console.error('Invalid response format from category_api.php', data);
            }
        },
        error: function(xhr, status, error) {
            console.error('Failed to load categories:', error);
        }
    });
}


function populateMentors(selectorId, selectedId = null, callback = null) {
    $.ajax({
        url: './apis/dropdown_api.php',
        type: 'GET',
        dataType: 'json',
        success: function(data) {
            if (data && Array.isArray(data.mentors)) {
                let options = '<option value="">Select Mentor</option>';
                data.mentors.forEach(function(mentor) {
                    const selectedAttr = selectedId == mentor.id ? 'selected' : '';
                    const safeName = escapeHtml(mentor.name);
                    options += `<option value="${mentor.id}" ${selectedAttr}>${safeName}</option>`;
                });
                $(`#${selectorId}`).html(options).trigger('change');
                
                // Execute callback if provided
                if (callback && typeof callback === 'function') {
                    callback();
                }
            } else {
                console.error('Invalid response format from mentor API', data);
            }
        },
        error: function(xhr, status, error) {
            console.error('Failed to load mentors:', error);
        }
    });
}


function populateIndustryExpert(selectorId, selectedId = null) {
    $.ajax({
        url: './apis/expert_dropdown_api.php',
        type: 'GET',
        dataType: 'json',
        success: function(data) {
            if (data && Array.isArray(data.mentors)) {
                let options = '<option value="">Select Industry Expert</option>';
                data.mentors.forEach(function(mentor) {
                    const selectedAttr = selectedId == mentor.id ? 'selected' : '';
                    const safeName = escapeHtml(mentor.name);
                    options += `<option value="${mentor.id}" ${selectedAttr}>${safeName}</option>`;
                });
                $(`#${selectorId}`).html(options).trigger('change');
            } else {
                console.error('Invalid response format from expert API', data);
            }
        },
        error: function(xhr, status, error) {
            console.error('Failed to load industry experts:', error);
        }
    });
}



function populateTestimonials(selectorId, selectedId = null) {
    $.ajax({
        url: './apis/dropdown_api.php',
        type: 'GET',
        dataType: 'json',
        success: function(data) {
            if (data && Array.isArray(data.testimonials)) {
                let options = '<option value="">Select Testimonials</option>';
                data.testimonials.forEach(function(testimonial) {
                    const selectedAttr = selectedId == testimonial.id ? 'selected' : '';
                    const safeName = escapeHtml(testimonial.name);
                    options += `<option value="${testimonial.id}" ${selectedAttr}>${safeName}</option>`;
                });
                $(`#${selectorId}`).html(options).trigger('change');
            } else {
                console.error('Invalid testimonial response format', data);
            }
        },
        error: function(xhr, status, error) {
            console.error('Failed to load testimonials:', error);
        }
    });
}


function populateProposedCourses(selectorId, selectedId = null) {
    $.ajax({
        url: './apis/dropdown_api.php',
        type: 'GET',
        dataType: 'json',
        success: function(data) {
            if (data && Array.isArray(data.proposed_courses)) {
                let options = '<option value="">Select Proposed Courses</option>';
                data.proposed_courses.forEach(function(proposed_course) {
                    const selectedAttr = selectedId == proposed_course.id ? 'selected' : '';
                    const safeName = escapeHtml(proposed_course.name);
                    options += `<option value="${proposed_course.id}" ${selectedAttr}>${safeName}</option>`;
                });
                $(`#${selectorId}`).html(options).trigger('change');
            } else {
                console.error('Invalid proposed courses response format', data);
            }
        },
        error: function(xhr, status, error) {
            console.error('Failed to load proposed courses:', error);
        }
    });
}



function populateFaqs(selectorId, selectedId = null) {
    $.ajax({
        url: './apis/dropdown_api.php',
        type: 'GET',
        dataType: 'json',
        success: function(data) {
            if (data && Array.isArray(data.faqs)) {
                let options = '<option value="">Select FAQs</option>';
                data.faqs.forEach(function(faq) {
                    const selectedAttr = selectedId == faq.id ? 'selected' : '';
                    const safeName = escapeHtml(faq.name);
                    options += `<option value="${faq.id}" ${selectedAttr}>${safeName}</option>`;
                });
                $(`#${selectorId}`).html(options).trigger('change');
            } else {
                console.error('Invalid FAQ response format', data);
            }
        },
        error: function(xhr, status, error) {
            console.error('Failed to load FAQs:', error);
        }
    });
}



function populateModules(selectorId, selectedId = null) {
    $.ajax({
        url: './apis/module_dropdown_api.php',
        type: 'GET',
        dataType: 'json',
        success: function(data) {
            if (data && Array.isArray(data.modules)) {
                let options = '<option value="">Select Module</option>';
                data.modules.forEach(function(module) {
                    const selectedAttr = selectedId == module.id ? 'selected' : '';
                    const safeName = escapeHtml(module.name);
                    options += `<option value="${module.id}" ${selectedAttr}>${safeName}</option>`;
                });
                $(`#${selectorId}`).html(options).trigger('change');
            } else {
                console.error('Invalid module response format', data);
            }
        },
        error: function(xhr, status, error) {
            console.error('Failed to load modules:', error);
        }
    });
}


function populateCoursesModules(selectorId, courseId, selectedId = null) {
    $.ajax({
        url: './apis/courses_modules_dropdown_api.php',
        type: 'GET',
        data: { course_id: courseId },
        dataType: 'json',
        success: function(data) {
            if (data && Array.isArray(data.modules)) {
                let options = '<option value="">Select Module</option>';
                data.modules.forEach(function(module) {
                    const selectedAttr = selectedId == module.id ? 'selected' : '';
                    const safeName = escapeHtml(module.name);
                    options += `<option value="${module.id}" ${selectedAttr}>${safeName}</option>`;
                });
                $(`#${selectorId}`).html(options).trigger('change');
            } else {
                console.error('Invalid module response from API', data);
            }
        },
        error: function(xhr, status, error) {
            console.error('Failed to load modules:', error);
        }
    });
}



function populateSubModules(selectorId, moduleId, selectedId = null) {
    $.ajax({
        url: './apis/dropdown_api.php',
        type: 'GET',
        dataType: 'json',
        data: { module_id: moduleId },
        success: function(data) {
            if (data && Array.isArray(data.sub_modules)) {
                let options = '<option value="">Select Submodule</option>';
                data.sub_modules.forEach(function(submodule) {
                    const selectedAttr = selectedId == submodule.id ? 'selected' : '';
                    const safeName = escapeHtml(submodule.name);
                    options += `<option value="${submodule.id}" ${selectedAttr}>${safeName}</option>`;
                });
                $(`#${selectorId}`).html(options).trigger('change');
            } else {
                console.error('Invalid submodule response format', data);
            }
        },
        error: function(xhr, status, error) {
            console.error('Failed to load submodules:', error);
        }
    });
}

</script>