<?php 
$page_name = 'Notification History';
require_once('includes/connection.php');
require_once('includes/header.php');
?>

<div class="content-wrapper">
  <section class="content-header">
    <span style="margin-left: 10px;">Notification History</span>
  </section>

  <section class="content">
    <div class="box box-default">
      <div class="box-header with-border">
        <div class="col-md-4 response-msg" id="responseMessage"></div>
        <div class="box-body table-padding">

          <table id="dataGrid" class="table display">
            <thead style="background:#FAF7FE;">
              <tr>
                <th>Sr. No.</th>
                <th>Email Title</th>
                <th>Subject</th>
                <th>Course</th>
                <th>Students</th>
              </tr>
            </thead>
          </table>

        </div>
      </div>
    </div>
  </section>
</div>


<div class="modal fade" id="emailModal" tabindex="-1">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">

      <div class="modal-header">
        <h4 class="modal-title">Student Emails</h4>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>

      <div class="modal-body">
        <table class="table table-bordered">
          <thead>
            <tr>
              <th>Sr. No.</th>
              <th>Email</th>
            </tr>
          </thead>
          <tbody id="emailList"></tbody>
        </table>
      </div>

    </div>
  </div>
</div>

<?php require_once('includes/footer.php'); ?>

<script>
let dataTable;


const sortState = {
  field: 'notification_id',
  dir: 'desc'
};

function openStudentModal(notificationId) {
  $('#emailList').html('<tr><td colspan="2">Loading...</td></tr>');
  $('#emailModal').modal('show');

  $.ajax({
    url: 'apis/get_notification_emails_api.php',
    type: 'POST',
    data: { notification_id: notificationId },
    dataType: 'json',
    success: function(res) {
      if (res.status === 'success' && res.emails.length > 0) {
        let rows = '';
        res.emails.forEach((email, index) => {
          rows += `
            <tr>
              <td>${index + 1}</td>
              <td>${email}</td>
            </tr>`;
        });
        $('#emailList').html(rows);
      } else {
        $('#emailList').html('<tr><td colspan="2">No emails found</td></tr>');
      }
    },
    error: function() {
      $('#emailList').html('<tr><td colspan="2">Server error</td></tr>');
    }
  });
}


const initDataTable = () => {
  dataTable = $('#dataGrid').DataTable({
    processing: true,
    serverSide: true,
    ordering: false,
    autoWidth: false,

    ajax: {
      url: 'apis/notification_history_api.php',
      type: 'POST',
      data: d => {
        d.sortField = sortState.field;
        d.sortDir   = sortState.dir;
      }
    },

    columns: [
      {
        data: null,
        render: (d, t, r, meta) =>
          meta.row + meta.settings._iDisplayStart + 1
      },
      { data: 'email_title' },
      { data: 'subject' },
      { data: 'course_title' },
	{
	  data: 'notification_id',
	  searchable: false,
	  render: id => {
	    const encId = btoa(id);
	    return `
	      <button class="btn btn-xs btn-primary"
	        onclick="openStudentModal(${id})">
	        View Emails
	      </button>
	      <a href="view_email_content.php?id=${encId}">
	        <img src="images/view.svg" />
	      </a>
	    `;
	  }
	}

    ],

    initComplete: function () {
      const w = $('#dataGrid_filter input').outerWidth();
      const sortUI = `
        <label style="margin-left:10px;">
          Sort By:
          <select id="sortField" class="form-control input-sm" style="width:${w}px;">
            <option value="email_title">Email Title</option>
            <option value="subject">Subject</option>
            <option value="course_title">Course</option>
          </select>
          <span id="sortToggleIcon" title="Sort Descending" style="cursor:pointer;">
            ${sortState.dir === 'desc' ? '▼' : '▲'}
          </span>
        </label>
      `;
      $('#dataGrid_filter').append(sortUI);
      
            $('#sortField').val(sortState.field).select2({
        placeholder: "Select Field",
        containerCssClass: 'select2-table-sort'
      });

      $('#dataGrid_length select').select2({
        minimumResultsForSearch: Infinity,
        containerCssClass: 'select2-table-sort'
      });
      
    }
  });
};

$(document).ready(() => {
  initDataTable();

  $(document).on('change', '#sortField', function () {
    sortState.field = $(this).val();
    dataTable.ajax.reload();
  });

  $(document).on('click', '#sortToggleIcon', function () {
    sortState.dir = (sortState.dir === 'desc') ? 'asc' : 'desc';
        $(this).text(sortState.dir === 'desc' ? '▼' : '▲')
           .attr('title', `Sort ${sortState.dir === 'desc' ? 'Descending' : 'Ascending'}`);
    dataTable.ajax.reload();
  });
});
</script>

</body>
</html>