<?php
$page_name = 'Bulk Notification';

require_once('includes/connection.php');
require_once('includes/header.php');
?>

<div class="content-wrapper">
    <section class="content-header">
        <span class="p-10">
            SEND BULK NOTIFICATION
        </span>
        <ol class="breadcrumb">
            <li><a href="masters.php">Masters</a></li>
            <li><a href="student_master.php">Student</a></li>
            <li class="active">Bulk Notification</li>
        </ol>
    </section>

    <section class="content">
        <div class="box box-default">
            <div class="box-header with-border">
                <div class="col-md-6 response-msg" id="responseMessage"></div>
            </div>

            <form id="emailForm">
                <div class="box-body">
                    <div class="col-md-12">

                        <div class="form-group clearfix">
                            <label class="col-md-2 col-form-label"><b>Email Content</b></label>
                        </div>

                        <div class="form-group clearfix">
                            <label class="col-md-2 col-form-label">Email Title</label>
                            <div class="col-md-6">
                                <input type="text" class="form-control" id="email_title" required>
                            </div>
                        </div>

                        <div class="form-group clearfix">
                            <label class="col-md-2 col-form-label">Institute</label>
                            <div class="col-md-6">
                                <select class="form-control select2" id="institute" style="width:100%;" required></select>
                            </div>
                        </div>

                        <div class="form-group clearfix">
                            <label class="col-md-2 col-form-label">Course</label>
                            <div class="col-md-6">
                                <select class="form-control select2" id="course" style="width:100%;" required></select>
                            </div>
                        </div>

                        <div class="form-group clearfix">
                            <label class="col-md-2 col-form-label">Subject</label>
                            <div class="col-md-6">
                                <input type="text" class="form-control" id="subject" required>
                            </div>
                        </div>

                        <div class="form-group clearfix">
                            <label class="col-md-2 col-form-label">Message</label>
                            <div class="col-md-6">
                                <textarea class="form-control" id="email_message" rows="5"></textarea>
                            </div>
                        </div>

                        <div class="box-footer" style="margin-top:30px;">
                            <button type="submit" class="btn btn-primary" id="btnText">Send</button>
                            <button type="button" class="btn btn-secondary" onclick="window.location.href='settings.php'">Cancel</button>
                        </div>

                    </div>
                </div>
            </form>
        </div>
    </section>
</div>

<?php require_once('includes/footer.php'); ?>

<script>


$(document).ready(function () {
    populateInstitutes('institute');
    populateCourses('course');

    $('#emailForm').on('submit', function (e) {
        e.preventDefault();

        const btn = $('#btnText');
        btn.prop('disabled', true).text('Sending...');

        const postData = {
            email_title: $('#email_title').val(),
            course_id: $('#course').val(),
            institute_id: $('#institute').val(),
            subject: $('#subject').val(),
            email_content: tinymce.get('email_message').getContent()
        };

        $.ajax({
            url: 'apis/save_bulk_student_notification_api.php',
            type: 'POST',
            data: postData,
            dataType: 'json',
            success: function (res) {
                if (res.status === 'success') {
                    showAlert(res.message, 'success');
                    $('#emailForm')[0].reset();
                    tinymce.get('email_message').setContent('');
                    $('.select2').val(null).trigger('change');
                } else {
                    showAlert(res.message, 'danger');
                }
                btn.prop('disabled', false).text('Send');
            },
            error: function () {
                showAlert('Server error occurred', 'danger');
                btn.prop('disabled', false).text('Send');
            }
        });
    });
});
</script>

<script src="tinymce_editor/tinymce/js/tinymce/tinymce.min.js"></script>
<script>
tinymce.init({
    selector: '#email_message',
    height: 250,
    menubar: false,
    plugins: [
        'advlist autolink lists link image charmap print preview anchor',
        'searchreplace visualblocks code fullscreen',
        'insertdatetime media table paste code help wordcount'
    ],
    toolbar: 'undo redo | formatselect | bold italic underline | alignleft aligncenter alignright | bullist numlist | link image | removeformat | help',
    content_css: 'tinymce_editor/tinymce/skins/content/default/content.css',
    init_instance_callback: function(editor) {
        // Prefill content if editing
        const urlParams = new URLSearchParams(window.location.search);
        const encodedId = urlParams.get('id');
        if (!encodedId) return;

        $.ajax({
            url: 'apis/get_template_prefill_api.php',
            type: 'GET',
            data: { id: encodedId },
            dataType: 'json',
            success: function (res) {
                if (res.status === 'success') {
                    $('#email_title').val(res.data.email_title);
                    $('#subject').val(res.data.subject);

                    if (res.data.email_content) {
                        editor.setContent(res.data.email_content);
                    }

                    if (res.data.course_id) $('#course').val(res.data.course_id).trigger('change');
                    if (res.data.institute_id) $('#institute').val(res.data.institute_id).trigger('change');
                } else {
                    showAlert(res.message, 'danger');
                }
            },
            error: function () {
                showAlert('Failed to load notification data', 'danger');
            }
        });
    }
});
</script>

</body>
</html>