<?php 
$page_name = 'Settings';
require_once('includes/connection.php');
require_once('includes/header.php');
?>

<style>
.notification-btn-wrapper {
  display: flex;
  flex-direction: column;
  gap: 15px;
  max-width: 260px;
}

.notification-btn {
  background-color: #5C2C8B;
  color: #fff;
  text-align: center;
  padding: 14px 20px;
  border-radius: 10px;
  font-size: 15px;
  font-weight: 500;
  text-decoration: none;
  transition: background-color 0.3s ease;
}

.notification-btn:hover {
  background-color: #4a226f;
  color: #fff;
  text-decoration: none;
}

</style>

  <div class="content-wrapper">
    <section class="content-header">
      <span style="margin-left: 10px;">
        Settings
      </span>
      <ol class="breadcrumb">
        <li><a href="settings.php">Settings</a></li>
      </ol>
    </section>

    <section class="content">
    <div class="row">

<div class="col-md-12">

  <div class="notification-btn-wrapper">
    <a href="send_notification.php" class="notification-btn">Send Notification</a>
    <a href="templates.php" class="notification-btn">Templates</a>
    <a href="notification_history.php" class="notification-btn">Notification History</a>
  </div>
</div>
        

      </div>
    </section>
  </div>
  
<?php require_once('includes/footer.php'); ?>

<script>
$(document).ready(function() {
    $.ajax({
        url: 'apis/get_master_counts.php',
        method: 'GET',
        dataType: 'json',
        success: function(response) {
            if (response.status === 'success') {
                $('#categoryCount').text(response.data.category); // Display category count
                $('#employeeCount').text(response.data.employee); // Display employee count
                $('#instituteCount').text(response.data.institute); // Display institute count
                $('#mentorCount').text(response.data.mentor); // Display mentor count
                $('#moduleCount').text(response.data.module); // Display module count
                $('#submoduleCount').text(response.data.submodule); // Display submodule count
                $('#faqCount').text(response.data.faq); // Display faq count
                
                $('#testimonialCount').text(response.data.testimonial); // Display testimonial count 
                
                $('#studentCount').text(response.data.students);
            } else {
                alert('Error: ' + response.message);
            }
        },
        error: function(xhr, status, error) {
            console.error('Error fetching data:', error);
            alert('An error occurred while fetching data.');
        }
    });
});
</script>

</body>
</html>