<?php 
$page_name = 'Study Material Assign';
require_once('includes/connection.php');
require_once('includes/header.php');

// Capture the module ID from URL
$moduleId = base64_decode($_GET['id']);
?>

<div class="content-wrapper">
    <section class="content-header">
      <span style="margin-left: 10px;">Study Materials Assign</span>
      <ol class="breadcrumb">
        <li><a href="masters.php">Masters</a></li>
        <li class="active">Study Materials Assign</li>
      </ol>
    </section>

    <section class="content">
        <div class="box box-default">
            <div class="box-header with-border">
                <div class="col-md-4 response-msg" id="responseMessage"></div>
                <div class="box-body table-padding">

                    <div id="loader" style="display: none;">
                        <p class="text-center">Loading...</p>
                    </div>

                    <table id="dataGrid" class="table">
                        <thead style="background: #FAF7FE;">
                            <tr>
                                <th>Sr. No.</th>
                                <th>Title</th>
                                <th>File Type</th>
                                <th>Preview</th>
                                <th>Select</th>
                            </tr>
                        </thead>
                        <tbody></tbody>
                    </table>

                    <div id="vimeoPlayerWrapper" style="margin-top:20px;"></div>

                    <!-- Submit Button -->
                    <div style="margin-top:20px;">
                        <button type="button" class="btn btn-primary" onclick="submitSelectedMaterials()">
                            Assign Selected Study Materials
                        </button>
                    </div>

                </div>
            </div>
        </div>
    </section>
</div>

<?php require_once('includes/footer.php'); ?>

<script>
let studyMaterials = [];
const moduleId = '<?php echo $moduleId; ?>';  // Pass PHP module ID into JS
let assignedStudyMaterials = [];  // Array to store assigned study materials

function fetchData() {
    $('#loader').show();

    $.ajax({
        url: 'apis/study_material_api.php',
        method: 'GET',
        dataType: 'json',
        success: function(data) {
            studyMaterials = data;
            buildTable(data);
            fetchAssignedMaterials();  // Fetch assigned study materials
            $('#loader').hide();
        },
        error: function(error) {
            console.error('Error fetching data:', error);
            $('#loader').hide();
        }
    });
}

function fetchAssignedMaterials() {
    $.ajax({
        url: 'apis/get_assigned_study_materials.php', // API to fetch assigned materials
        method: 'GET',
        dataType: 'json',
        data: { module_id: moduleId },
        success: function(data) {
            console.log(data);  // Log the raw data returned by the API
            // If the data is a string like "9,1", split it into an array
            assignedStudyMaterials = data[0].split(','); // Split by comma to get individual IDs
            preselectCheckboxes(); // Pre-select checkboxes for assigned materials
        },
        error: function(error) {
            console.error('Error fetching assigned study materials:', error);
        }
    });
}

function preselectCheckboxes() {
    // Loop through the assigned materials and check the corresponding checkboxes
    $('input[name="study_material[]"]').each(function() {
        const studyMaterialId = $(this).val();
        // Check if the current checkbox value is in the assigned study materials array
        if (assignedStudyMaterials.includes(studyMaterialId)) {
            $(this).prop('checked', true);  // Pre-select the checkbox
        }
    });
}


function buildTable(data) {
    const tableBody = $('#dataGrid tbody');
    tableBody.empty();

    let tableRows = '';
    data.forEach((item, index) => {
        const fileType = item.vimeo_link ? 'Video' : 'PDF / Image';
        tableRows += `
            <tr>
                <td>${index + 1}</td>
                <td>${item.title}</td>
                <td>${fileType}</td>
                <td><a href="#" onclick="showPreview(${index}); return false;">Preview</a></td>
                <td>
                    <input type="checkbox" name="study_material[]" 
                           id="study_material_${item.study_material_id}" 
                           value="${item.study_material_id}">
                </td>
            </tr>
        `;
    });

    tableBody.html(tableRows);
}

function showPreview(index) {
    const item = studyMaterials[index];

    if (item.vimeo_link) {
        window.open(`https://player.vimeo.com/video/${item.vimeo_link}`, '_blank');
    } else if (item.actual_file_name) {
        const fileName = item.actual_file_name.toLowerCase();
        const filePath = `https://kapps.co.in/EPIC_LMS_DEVELOPMENT/study/${item.actual_file_name}`;

        if (fileName.endsWith('.pdf') || /\.(jpg|jpeg|png|gif)$/.test(fileName)) {
            window.open(filePath, '_blank');
        } else {
            alert('Unsupported file type for preview.');
        }
    } else {
        alert('No video or file available.');
    }
}

function submitSelectedMaterials() {
    let selectedIds = [];
    $('input[name="study_material[]"]:checked').each(function() {
        selectedIds.push($(this).val());
    });

    if (selectedIds.length === 0) {
        alert('Please select at least one study material.');
        return;
    }

    $.ajax({
        url: 'apis/submit_module_study_materials.php?id=' + moduleId,
        method: 'POST',
        dataType: 'json',
        data: { ids: selectedIds.join(',') },
        success: function(response) {
            // Use the showAlert function to display success message
            if (response.status === 'success') {
                showAlert(response.message, 'success');
            } else {
                showAlert(response.message, 'danger');
            }
        },
        error: function(xhr, status, error) {
            // Log the error and show an alert with error message
            console.error(error);
            showAlert('Error submitting study materials.', 'danger');
        }
    });
}

$(document).ready(function() {
    fetchData();
});
</script>

</body>
</html>
