<?php 
$page_name = 'Email Templates';
require_once('includes/connection.php');
require_once('includes/header.php');
?>

<div class="content-wrapper">
  <section class="content-header">
    <span style="margin-left: 10px;">Email Templates</span>
    <a href="add_email_template.php" style="float:right;" class="btn btn-primary">
      Add Template
    </a>
  </section>

  <section class="content">
    <div class="box box-default">
      <div class="box-header with-border">
        <div class="col-md-4 response-msg" id="responseMessage"></div>
        <div class="box-body table-padding">

          <table id="dataGrid" class="table display">
            <thead style="background:#FAF7FE;">
              <tr>
                <th>Sr. No.</th>
                <th>Email Title</th>
                <th>Action</th>
              </tr>
            </thead>
          </table>

        </div>
      </div>
    </div>
  </section>
</div>

<?php require_once('includes/footer.php'); ?>

<script>
const sortState = {
  field: 'email_title',
  dir: 'asc'
};

let dataTable;


const initDataTable = () => {
  dataTable = $('#dataGrid').DataTable({
    processing: true,
    serverSide: true,
    ordering: false,
    autoWidth: false,

    columnDefs: [
      { width: "70px", targets: 0 },
      { width: "400px", targets: 1 },
      { width: "120px", targets: 2 }
    ],

    ajax: {
      url: 'apis/template_api.php',
      type: 'POST',
      data: d => {
        d.sortField = sortState.field;
        d.sortDir   = sortState.dir;
      },
      beforeSend: () => $('#page-loader').show(),
      complete: () => $('#page-loader').hide()
    },

    columns: [
      {
        data: null,
        render: (d, t, r, meta) =>
          meta.row + meta.settings._iDisplayStart + 1
      },
      {
        data: 'email_title',
        render: data => $('<div/>').text(data).html()
      },
      {
        data: 'notification_template_id',
        searchable: false,
        orderable: false,
        render: id => {
          const encId = btoa(id.toString());
          return `
            <a href="edit_email_template.php?id=${encId}">
              <img src="images/edit.svg" />
            </a>
            <a href="send_notification.php?id=${encId}">
              <i class="fa fa-check" data-course-id="48" style="margin-left: 10px; background: #5D2B8B; border-radius: 50%; padding: 7px; color: #fff; font-size: 12px;" title="Select Template"></i>
            </a>
          `;
        }
      }
    ],

    initComplete: () => {
      const w = $('#dataGrid_filter input').outerWidth();
      const sortUI = `
        <label style="margin-left:10px;">
          Sort By:
          <select id="sortField" class="form-control input-sm" style="width:${w}px;">
            <option value="email_title">Email Title</option>
          </select>
          <span id="sortToggleIcon" style="cursor:pointer;">
            ${sortState.dir === 'desc' ? '▼' : '▲'}
          </span>
        </label>
      `;
      $('#dataGrid_filter').append(sortUI);

      $('#sortField').select2({
        minimumResultsForSearch: Infinity,
        containerCssClass: 'select2-table-sort'
      });

      $('#dataGrid_length select').select2({
        minimumResultsForSearch: Infinity,
        containerCssClass: 'select2-table-sort'
      });
    }
  });
};

$(document).ready(() => {
  initDataTable();

  $(document).on('click', '#sortToggleIcon', function () {
    sortState.dir = sortState.dir === 'asc' ? 'desc' : 'asc';
    $(this).text(sortState.dir === 'desc' ? '▼' : '▲');
    dataTable.ajax.reload();
  });
});
</script>

</body>
</html>