<?php 
$page_name = 'Masters';
require_once('includes/connection.php');
require_once('includes/header_user.php');
?>

<style>

.skin-blue .main-header .navbar {
    background-color: #fff;
}

.login-profile {
    height: 90px;
}

.content-wrapper, .main-footer {
  margin-left: unset !important;
}

.main-header .navbar {
  margin-left: unset !important;    
}

.skin-blue .main-header .navbar {
  border-bottom: 1px solid #5C2C8B;
}

.progress-bar {
  background-color: #5C2C8B;
}

.module-list {
  list-style: none;
  padding: 0;
  margin-top: 15px;
}

.module-list li {
  padding: 5px 15px;
  border-radius: 5px;
  margin-bottom: 15px;
  background-color: #fff;
  cursor: pointer;
  border: 1px solid #ddd;
  transition: all 0.3s ease;
  color: #333;
}

.module-list li:hover {
  background-color: #f2e8fc;
  color: #5C2C8B;
}

.module-list li.active {
  background-color: #E9DFF8;
  color: #5C2C8B;
  font-weight: 600;
  border-left: 5px solid #5C2C8B;
}

.btn-dark {
  background-color: #5C2C8B;
  border-color: #5C2C8B;
}

.course-box {
  padding: 30px 0px;
}



#moduleTitle {
  color: #5C2C8B;
  font-size: 22px;
  font-weight: bold;
}

iframe {
  border-radius: 8px;
}

.quiz-box {
  padding: 30px;
  background-color: #f3ecff;
  border: 2px dashed #5C2C8B;
  border-radius: 10px;
  text-align: center;
  font-size: 18px;
  color: #5C2C8B;
  font-weight: bold;
}

@media (max-width: 767px) {
  .col-md-4, .col-md-8 {
    padding: 10px;
  }
}

.video-container {
  position: relative;
  padding-bottom: 56.25%; /* 16:9 ratio */
  height: 0;
  overflow: hidden;
  margin-bottom: 20px;
  border-radius: 8px;
  box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
}

.video-container iframe {
  position: absolute;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  border: none;
}


.timeline-toggle {
  margin-bottom: 20px;
  border-radius: 50px !important;
}

.timeline-wrapper {
      border-left: 2px dashed #6A1B9A;
  padding-left: 20px;
  margin-left: 15px;
  max-width: 300px;
}

.timeline-item {
  display: flex;
  align-items: flex-start;
}


.timeline-icon {
  font-size: 20px;
  margin-right: 10px;
  color: #6a1b9a;
}

.timeline-content h4 {
  margin: 0;
  color: #6a1b9a;
  font-size: 16px;
}

.timeline-content p {
  margin: 3px 0 0;
  font-size: 14px;
}

.assignment p {
  font-weight: bold;
}

.assignment.completed p {
  color: #4caf50;
}

.assignment.due-soon p {
  color: #ff5722;
}

.assignment.upcoming p {
  color: #ff9800;
}


.progress {
    height: 5px;
}

.btn-right {
    float: right;
}


.timeline-container {
  display: flex;
  flex-direction: column;
  max-width: 250px;
}



.icon-wrapper {
  display: flex;
  flex-direction: column;
  align-items: center;
  margin-right: 10px;
  position: relative;
  width: 24px;
}

.icon {
  width: 20px;
  height: 20px;
  z-index: 2;
}

.line {
  width: 2px;
  height: 50px;
  border-left: 2px dashed #a259cf;
  margin-top: 2px;
  z-index: 1;
}

.content .label {
  font-weight: bold;
  color: #6a1b9a;
  font-size: 16px;
  padding: unset;
}

.content .date {
  font-size: 14px;
  color: #6a1b9a;
}

.content {
    background: #F7F5F9 !important;
        padding: 0px 20px !important;
}

.course-title
{
        color: #5B2E8E;
    line-height: 30px;
    font-size: 20px;
}
</style>

<div class="content-wrapper">
  <section class="content">
    <div class="row">
      <div class="col-md-3">
          <div class="course-box">
        <h4 class="course-title"><strong>Clinical Data Management Demystified</strong></h4>
        <p>– By Deven Babre</p>
        <br>

        <div class="progress">
          <div class="progress-bar" style="width: 0%"></div>
        </div>
        <div><span id="progressText">0%</span> Completed</div>
        <br>
        
        <ul class="module-list mt-3" id="moduleList">
          <!-- Modules will be inserted dynamically -->
        </ul>

<button type="button" onclick="toggleTimeline()" class="btn btn-block btn-primary btn-flat timeline-toggle" style="    margin-top: 50px;">Course Timeline</button>



<div class="timeline-container" id="courseTimeline" style="display: none;    padding-left: 20px;">
  <div class="timeline-item">
    <div class="icon-wrapper">
      <img src="icons/feather-map-pin.svg" alt="Start Icon" class="icon" />
      <div class="line"></div>
    </div>
    <div class="content1">
      <div class="label">Start Date</div>
      <div class="date">29th Dec. 2024</div>
    </div>
  </div>

  <div class="timeline-item">
    <div class="icon-wrapper">
      <img src="icons/feather-award.svg" alt="End Icon" class="icon" />
    </div>
    <div class="content1">
      <div class="label">End Date</div>
      <div class="date">29th Jan. 2025</div>
    </div>
  </div>
</div>

      </div>
      </div>

      <div class="col-md-9">
        <div class="course-box">
          <h4 id="moduleTitle">Course Content</h4>
          <p>– By Expert Deven Babre (28+ Yrs Experience)</p>

          <div id="moduleContent" class="mt-4">
            <!-- Dynamic Content Goes Here -->
          </div>

    <div class="btn-right mt-4">
      <button type="button" class="btn btn-secondary" onclick="prevContent()">< Previous</button>
      <button type="button" class="btn btn-primary btn-right-mrg" onclick="nextContent()">Next ></button>
    </div>

        </div>
      </div>
    </div>
  </section>
</div>



<script>
const modules = [
  {
    title: 'Module 1 - General',
    contents: [
      { type: 'video', title: 'Intro Video', src: 'https://www.youtube.com/embed/O6Xo21L0ybE' },
      { type: 'pdf', title: 'Module 1 Notes', src: 'https://www.princexml.com/samples/icelandic/dictionary.pdf' },
      { type: 'text', title: 'Module 1 Summary', content: 'This is a short summary of Module 1 content.' },
      { type: 'quiz', title: 'Quiz - Module 1', link: 'quiz_module1.php' }
    ]
  },
  {
    title: 'Module 2 - Study',
    contents: [
      { type: 'video', title: 'Study Process', src: 'https://www.youtube.com/embed/ysz5S6PUM-U' },
      { type: 'pdf', title: 'Study PDF', src: 'https://www.princexml.com/samples/icelandic/dictionary.pdf' },
      { type: 'text', title: 'Module 2 Notes', content: 'Some text explanation for Module 2.' }
    ]
  },
  {
    title: 'Module 3 - Wrap-up',
    contents: [
      { type: 'video', title: 'Conclusion', src: 'https://www.youtube.com/embed/dQw4w9WgXcQ' }
    ]
  }
];

let flatContent = [];
let currentIndex = 0;

function flattenModules() {
  flatContent = [];
  modules.forEach((mod, modIndex) => {
    mod.contents.forEach((item, i) => {
      flatContent.push({ ...item, moduleIndex: modIndex });
    });
  });
}

function buildSidebar() {
  const ul = document.getElementById('moduleList');
  ul.innerHTML = '';
  modules.forEach((mod, i) => {
    const li = document.createElement('li');
    li.innerText = mod.title;
    li.onclick = () => {
      const idx = flatContent.findIndex(fc => fc.moduleIndex === i);
      if (idx !== -1) {
        currentIndex = idx;
        renderContent();
      }
    };
    ul.appendChild(li);
  });
}

function updateSidebarHighlight() {
  const activeModuleIndex = flatContent[currentIndex].moduleIndex;
  const listItems = document.querySelectorAll('.module-list li');
  listItems.forEach((li, i) => {
    li.classList.toggle('active', i === activeModuleIndex);
  });
}

function renderContent() {
  const item = flatContent[currentIndex];
  const container = document.getElementById('moduleContent');
  const titleEl = document.getElementById('moduleTitle');

  titleEl.innerText = item.title;
  updateSidebarHighlight();

  let html = '';
  if (item.type === 'video') {
    html = `<div class="video-container"><iframe src="${item.src}" allowfullscreen></iframe></div>`;
  } else if (item.type === 'pdf') {
  html = `<embed src="${item.src}" type="application/pdf" width="100%" height="600px" />`;
}else if (item.type === 'text') {
    html = `<div style="background: white; color: black; padding: 20px; border-radius: 8px;">${item.content}</div>`;
  } else if (item.type === 'quiz') {
    html = `<div class="quiz-box">Take the quiz: <a href="${item.link}" class="btn btn-dark mt-3">Start Quiz</a></div>`;
  }

  container.innerHTML = html;

  const percent = Math.round(((currentIndex + 1) / flatContent.length) * 100);
  document.querySelector('.progress-bar').style.width = percent + '%';
  document.getElementById('progressText').innerText = `${percent}%`;

  window.scrollTo({ top: 0, behavior: 'smooth' });
}

function nextContent() {
  if (currentIndex < flatContent.length - 1) {
    currentIndex++;
    renderContent();
  }
}

function prevContent() {
  if (currentIndex > 0) {
    currentIndex--;
    renderContent();
  }
}

// Initialize
flattenModules();
buildSidebar();
renderContent();
</script>

<script>
  function toggleTimeline() {
    const timeline = document.getElementById("courseTimeline");
    timeline.style.display = (timeline.style.display === "none") ? "block" : "none";
  }
</script>


<?php require_once('includes/footer.php'); ?>
</body>
</html>