<?php
$page_name = 'View Assignment';
require_once('includes/connection.php');
require_once('includes/header.php');
?>
<div class="content-wrapper">
  <section class="content-header">
    <span class="p-10">VIEW ASSIGNMENT</span>
    <ol class="breadcrumb">
      <li><a href="masters.php">Masters</a></li>
      <li><a href="assignment_master.php">Assignment</a></li>
      <li class="active">View Assignment</li>
    </ol>
  </section>
  <section class="content">
    <div class="box box-default">
      <div class="box-header with-border">
        <p class="box-title">* All fields are required.</p>
        <div class="col-md-4 response-msg" id="responseMessage"></div>
      </div>
      <form id="assignmentForm" enctype="multipart/form-data">
        <div class="box-body">
          <div class="row">
            
            <div class="col-md-4">
              <div class="form-group">
                <label for="assignmentTitle">Assignment Title</label>
                <input type="text" id="assignmentTitle" name="assignmentTitle" class="form-control" readonly />
              </div>
            </div>

            <div class="col-md-2">
              <div class="form-group">
                <label>Marks</label>
                <input class="form-control" type="text" autocomplete="off" id="totalMarks" name="totalMarks" readonly>
              </div>
            </div>
            
            <div class="col-md-2">
              <div class="form-group">
                <label>Duration (Sec)</label>
                <input class="form-control" type="text" autocomplete="off" id="totalDuration" name="totalDuration" readonly>
              </div>
            </div>            
            
          </div>
        </div>
        <div class="box-body table-padding">
          <table id="dataGrid" class="table display">
            <thead style="background: #FAF7FE;">
              <tr>
                <th><input type="checkbox" id="select-all" style="margin-top: -15px;" disabled /></th>
                <th>Question</th>
                <th>Category</th>
                <th>Media</th>
                <th>Marks</th>
                <th>Time (Sec)</th>
              </tr>
            </thead>
          </table>
        </div>
        <div class="box-footer">
          <input type="hidden" name="selected_questions" id="selected_questions" />
          <button type="submit" class="btn btn-primary">Submit</button>
          <a href="assignment_master.php" class="btn btn-secondary">Back</a>
        </div>
      </form>
    </div>
  </section>
</div>
<?php require_once('includes/footer.php'); ?>
<script>
let dataTable;
let selectedQuestions = new Set();

$(document).ready(function () {

  function updateTotals() {
    let totalMarks = 0, totalDuration = 0;
    $('#dataGrid .question-checkbox:checked').each(function () {
      const row = $(this).closest('tr');
      totalMarks   += parseFloat(row.find('td:eq(4)').text()) || 0;
      totalDuration += parseFloat(row.find('td:eq(5)').text()) || 0;
    });
    $('#totalMarks').val(totalMarks);
    $('#totalDuration').val(totalDuration);
  }

  const urlParams = new URLSearchParams(window.location.search);
  const assignmentId = urlParams.get('id');

  dataTable = $('#dataGrid').DataTable({
    processing: true,
    serverSide: true,
    ordering: false,
    autoWidth: false,
    language: { search: "Search:" },
    ajax: {
      url: 'apis/assignment_question_api.php',
      type: 'POST',
      data: function (d) {
        d.category_id = $('#category').val();
        d.criteria = 'assignment';
        // ✅ If editing, send selected IDs to pre-check them
        if (selectedQuestions.size > 0) {
          d.selected_ids = Array.from(selectedQuestions).join(',');
        }
      },
      beforeSend: function () { $('#page-loader').show(); },
      complete: function () { $('#page-loader').hide(); }
    },
    columns: [
      {
        data: 'question_master_id',
        orderable: false,
        render: function (data) {
          const checked = selectedQuestions.has(data.toString()) ? 'checked' : '';
          return `<input type="checkbox" class="question-checkbox" value="${data}" ${checked} disabled>`;
        }
      },
      { data: 'question' },
      { data: 'category_name' },
      { data: 'media' },
      { data: 'marks' },
      { data: 'duration' }
    ],
    initComplete: function () {
      $('#dataGrid_filter input[type=search]').addClass('responsive-input');
    }
  });

  $('#category').on('change', function () {
    dataTable.ajax.reload();
  });

  $('#dataGrid').on('change', '.question-checkbox', function () {
    const id = this.value;
    this.checked ? selectedQuestions.add(id) : selectedQuestions.delete(id);

    const allVisible = $('#dataGrid .question-checkbox').length;
    const selectedVisible = $('#dataGrid .question-checkbox:checked').length;
    $('#select-all').prop('checked', allVisible > 0 && allVisible === selectedVisible);

    updateTotals();
  });

  $('#select-all').on('change', function () {
    const isChecked = this.checked;
    $('#dataGrid .question-checkbox').each(function () {
      this.checked = isChecked;
      const id = this.value;
      isChecked ? selectedQuestions.add(id) : selectedQuestions.delete(id);
    });
    updateTotals();
  });

  $('#dataGrid').on('draw.dt', function () {
    $('#dataGrid .question-checkbox').each(function () {
      const id = this.value;
      this.checked = selectedQuestions.has(id);
    });
    const allVisible = $('#dataGrid .question-checkbox').length;
    const selectedVisible = $('#dataGrid .question-checkbox:checked').length;
    $('#select-all').prop('checked', allVisible > 0 && allVisible === selectedVisible);
    updateTotals();
  });

  $('#assignmentForm').on('submit', function (e) {
    e.preventDefault();

    $('#selected_questions').val(JSON.stringify(Array.from(selectedQuestions)));
    const formData = new FormData(this);
    if (assignmentId) formData.append('assignmentId', assignmentId);

    const endpoint = assignmentId ? 'apis/edit_assignment_api.php' : 'apis/add_assignment_api.php';

    fetch(endpoint, { method: 'POST', body: formData })
      .then(res => res.json())
      .then(response => {
        if (response.status === 'success') showAlert(response.message, 'success');
        else showAlert(response.message, 'danger');
      })
      .catch(() => showAlert('An error occurred while processing your request.', 'danger'));
  });

  if (assignmentId) {
    prepopulateAssignmentForm(assignmentId);
  }
});
</script>


</body>
</html>