<?php 
$page_name = 'View Course';

require_once('includes/connection.php');
require_once('includes/header.php');

?>

  <div class="content-wrapper">
    <section class="content-header">
      <span class="p-10">
        VIEW NEW COURSE
      </span>
      <ol class="breadcrumb">
        <li><a href="masters.php"> Masters</a></li>
        <li><a href="course_master.php">Course</a></li>
        <li class="active">View Course</li>
      </ol>
    </section>
    
    
    <section class="content">
      <div class="box box-default">
        <div class="box-header with-border">
          <!--<p class="box-title">* All fields marked with an asterisk are required</p>-->
            <div class="col-md-4 response-msg" id="responseMessage">
            </div>  
        </div>

            <form id="courseForm">
    <div class="box-body">
        <div class="row">

            <div class="col-md-4">
                <div class="form-group">
                    <label>Course Name <span class="text-danger">*</span></label>
                    <input class="form-control" type="text" autocomplete="off" id="course_name" name="course_name" readonly>
                </div>
            </div>

            <div class="col-md-4">
                <div class="form-group">
                    <label>Course Category <span class="text-danger">*</span></label>
                    <select class="form-control select2" id="course_category" name="course_category" data-placeholder="Select Category"
                            style="width: 100%;" disabled>
                        <!-- Options will be populated dynamically -->
                    </select>
                </div>
            </div> 
            
            <div class="col-md-4">
                <div class="form-group">
                    <label>Level <span class="text-danger">*</span></label>
                    <select class="form-control select2" id="level" name="level" data-placeholder="Select Level"
                            style="width: 100%;" disabled>
                        <option value="1">Level 1</option>
                        <option value="2">Level 2</option>
                        <option value="3">Level 3</option>
                    </select>
                </div>
            </div>    

            <div class="col-md-4">
                <div class="form-group">
                    <label>Course Image</label>
                    <input class="form-control" type="file" autocomplete="off" id="course_img" name="course_img" accept="image/png, image/gif, image/jpeg" style="display: none">
                    <br>
                    <!-- Image Preview -->
                    <img id="course_img_preview" src="#" alt="No Image" style="max-height:100px; display:none; border:1px solid #ddd; padding:5px;">
                </div>
            </div>                        
            
            <div class="col-md-4">
                <div class="form-group">
                    <label>Description</label>
                    <textarea class="form-control" type="text" autocomplete="off" id="description" name="description" disabled></textarea>
                </div>
            </div>

        </div>

        <div class="box-footer">
            <a href="course_master.php" class="btn btn-secondary">Back</a>
        </div>
    </div>
</form>

      </div>
    </section>
  </div>


<?php require_once('includes/footer.php'); ?>

<script>
$(document).ready(function () {

    // Fetch Categories
    $.ajax({
        url: 'apis/category_api.php',
        type: 'GET',
        dataType: 'json',
        success: function (data) {
            if (Array.isArray(data)) {
                let options = '';
                data.forEach(function (role) {
                    options += `<option value="${role.category_id}">${role.category_name}</option>`;
                });
                const categorySelect = $('#course_category');
                categorySelect.html(options);
                categorySelect.trigger('change');
            } else {
                console.error('Error: Invalid response format', data);
            }
        },
        error: function (xhr, status, error) {
            console.error('Error occurred while fetching data:', error);
        }
    });
    

    const urlParams = new URLSearchParams(window.location.search);
    const courseId = urlParams.get('id');

    if (courseId) {
        prepopulateCourseForm(courseId);
    }
});

</script>

</body>
</html>