<?php 
$page_name = 'View Course Material';

require_once('includes/connection.php');
require_once('includes/header.php');
?>

<div class="content-wrapper">

<div id="uploadLoader"  style="display:none;">
  <div class="loader-overlay">
    <div class="loader-text">⏳ Your file is uploading, please wait...</div>
  </div>
</div>

  <section class="content-header">
    <span class="p-10">
      VIEW COURSE MATERIAL
    </span>
    <ol class="breadcrumb">
      <li><a href="masters.php"> Masters</a></li>
      <li><a href="course_material_master.php">Course Material</a></li>
      <li class="active">View Course Material</li>
    </ol>
  </section>
  
  <section class="content">
    <div class="box box-default">
      <div class="box-header with-border">
        <p class="box-title">* All fields marked with an asterisk are required</p>
        <div class="col-md-4 response-msg" id="responseMessage"></div>  
      </div>

      <form id="studyMaterialForm">
        <div class="box-body">
          <div class="row">
            <div class="col-md-4">
              <div class="form-group">
                <label>Study Title <span class="text-danger">*</span></label>
                <input class="form-control" type="text" id="study_title" name="study_title" readonly>
              </div>
            </div>

            <div class="col-md-4">
              <div class="form-group">
                <label>Category <span class="text-danger">*</span></label>
                <select class="form-control select2" id="category" name="category" style="width: 100%;" disabled></select>
              </div>
            </div>                        

            <div class="col-md-4">
              <div class="form-group">
                <label>Study Content <span class="text-danger">*</span></label>
                <input class="form-control" type="file" id="study_content" name="study_content" accept=".pdf,.ppt,.pptx,.png,.jpg,.jpeg,.mp4,.txt" disabled>
                <a id="studyLink" href="#" target="_blank" style="display: none;"></a>
              </div>
            </div>                        

            <div class="col-md-4">
              <div class="form-group">
                <label>Description</label>
                <textarea class="form-control" id="description" name="description" readonly></textarea>
              </div>
            </div> 
                
            <div class="col-md-4">
              <div class="form-group">
                <div class="radio">
                  <input name="block_content" value="0" type="radio" id="Option_1" class="with-gap radio-col-red" disabled>
                  <label for="Option_1">Active</label>                    
                </div>
                <div class="radio">
                  <input name="block_content" value="1" type="radio" id="Option_2" class="with-gap radio-col-red" disabled>
                  <label for="Option_2">Inactive</label>   
                </div>
              </div>
            </div>                         
          </div>
        
          <div class="box-footer">
            <a href="course_material_master.php" class="btn btn-secondary">Back</a>
          </div>
        </div>
      </form>
    </div>
  </section>
</div>

<?php require_once('includes/footer.php'); ?>

<script>
$(document).ready(function() {

    const urlParams = new URLSearchParams(window.location.search);
    const studyId = urlParams.get('id');

    if (studyId) {
        // Fetch the study material first to get the category_id
        $.ajax({
            url: `apis/get_study_single_api.php?id=${studyId}`,
            method: 'GET',
            success: function(data) {
                if (data.status === 'success') {
                    const selectedCategory = data.study_material.category_id;
                    // Populate categories with the selected value
                    populateCategories('category', selectedCategory);

                    // Call existing prepopulate function
                    prepopulateStudyMaterialForm(studyId);

                } else {
                    // fallback: populate normally
                    populateCategories('category');
                }
            },
            error: function(err) {
                console.error('Error fetching study material:', err);
                populateCategories('category');
            }
        });
    } else {
        // No studyId, populate normally
        populateCategories('category');
    }



});
</script>

</body>
</html>