<?php
$page_name = 'Email Content';

require_once('includes/connection.php');
require_once('includes/header.php');
?>

<div class="content-wrapper">
    <section class="content-header">
        <span class="p-10">
            View Email Content
        </span>
        <ol class="breadcrumb">
            <li><a href="masters.php">Masters</a></li>
            <li><a href="student_master.php">Student</a></li>
            <li class="active">Email Content</li>
        </ol>
    </section>

    <section class="content">
        <div class="box box-default">
            <div class="box-header with-border">
                <div class="col-md-6 response-msg" id="responseMessage"></div>
            </div>

            <form id="emailForm">
                <div class="box-body">
                    <div class="col-md-12">

                        <div class="form-group clearfix">
                            <label class="col-md-2 col-form-label"><b>Email Content</b></label>
                        </div>

                        <div class="form-group clearfix">
                            <label class="col-md-2 col-form-label">Email Title</label>
                            <div class="col-md-6">
                                <input type="text" class="form-control" id="email_title" readonly>
                            </div>
                        </div>

                        <div class="form-group clearfix">
                            <label class="col-md-2 col-form-label">Institute</label>
                            <div class="col-md-6">
                                <select class="form-control select2" id="institute" style="width:100%;" disabled></select>
                            </div>
                        </div>

                        <div class="form-group clearfix">
                            <label class="col-md-2 col-form-label">Course</label>
                            <div class="col-md-6">
                                <select class="form-control select2" id="course" style="width:100%;" disabled></select>
                            </div>
                        </div>

                        <div class="form-group clearfix">
                            <label class="col-md-2 col-form-label">Subject</label>
                            <div class="col-md-6">
                                <input type="text" class="form-control" id="subject" readonly>
                            </div>
                        </div>

                        <div class="form-group clearfix">
                            <label class="col-md-2 col-form-label">Message</label>
                            <div class="col-md-6">
                                <textarea class="form-control" id="email_message" rows="5"></textarea>
                            </div>
                        </div>

                        <div class="box-footer" style="margin-top:30px;">
                            <button type="button" class="btn btn-secondary"
                                onclick="window.location.href='notification_history.php'">
                                Back
                            </button>
                        </div>

                    </div>
                </div>
            </form>
        </div>
    </section>
</div>

<?php require_once('includes/footer.php'); ?>

<script>
$(document).ready(function () {
    populateInstitutes('institute');
    populateCourses('course');
});
</script>

<script src="tinymce_editor/tinymce/js/tinymce/tinymce.min.js"></script>
<script>
tinymce.init({
    selector: '#email_message',
    height: 250,
    menubar: false,
    readonly: true,
    plugins: [
        'advlist autolink lists link image charmap print preview anchor',
        'searchreplace visualblocks code fullscreen',
        'insertdatetime media table paste code help wordcount'
    ],
    toolbar: false,
    content_css: 'tinymce_editor/tinymce/skins/content/default/content.css',

    init_instance_callback: function(editor) {

        const urlParams = new URLSearchParams(window.location.search);
        const encodedId = urlParams.get('id');
        if (!encodedId) return;

        const notificationId = atob(encodedId);

        $.ajax({
            url: 'apis/get_email_content_api.php',
            type: 'POST',
            dataType: 'json',
            data: { notification_id: notificationId },
            success: function (res) {

                if (res.status !== 'success') {
                    $('#responseMessage').html(
                        '<span class="text-danger">' + res.message + '</span>'
                    );
                    return;
                }

                const d = res.data;

                $('#email_title').val(d.email_title);
                $('#subject').val(d.subject);

                $('#institute')
                    .val(d.institute_id)
                    .trigger('change');

                $('#course')
                    .val(d.course_id)
                    .trigger('change');

                editor.setContent(d.email_content);
            },
            error: function () {
                $('#responseMessage').html(
                    '<span class="text-danger">Server error while loading email content</span>'
                );
            }
        });
    }
});
</script>

</body>
</html>