<?php
$page_name = 'View Institute';

require_once('includes/connection.php');
require_once('includes/header.php');
?>

<style>
  #addMoreButton,
  .removeButton {
    display: none !important;
  }
  
.view-mode input {
    pointer-events: none;
}

</style>


<div class="content-wrapper view-mode">
    <section class="content-header">
        <span class="p-10">
            VIEW INSTITUTE
        </span>
        <ol class="breadcrumb">
            <li><a href="masters.php"> Masters</a></li>
            <li><a href="institute_master.php">Institute</a></li>
            <li class="active">View Institute</li>
        </ol>
    </section>


    <section class="content">
        <div class="box box-default">
            <div class="box-header with-border">
            </div>

            <form id="instituteForm">
                <div class="box-body">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Institute Name</label>
                                <input class="form-control" type="text" autocomplete="off" id="institute_name" name="institute_name" readonly>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Phone No.</label>
                                <input class="form-control" type="number" autocomplete="off" id="phone_no" name="phone_no" readonly>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Email ID</label>
                                <input class="form-control" type="email" autocomplete="off" id="email_id" name="email_id" readonly>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Password</label>
                                    <input class="form-control" type="password" autocomplete="off" id="password" name="password" readonly>
                                        <span class="input-group-text password-eye" id="togglePassword">
                                            <i class="fa fa-eye" id="eyeIcon"></i> <!-- Eye Icon -->
                                        </span>                                        
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>City</label>
                                <input class="form-control" type="text" autocomplete="off" id="city" name="city" readonly>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>State</label>
                                <input class="form-control" type="text" autocomplete="off" id="state" name="state" readonly>
                            </div>
                        </div>


                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Country</label>
                                <select class="form-control select2" id="country" name="country" data-placeholder="Select Country" style="width: 100%;" disabled>
                                    <!-- Options will be populated dynamically -->
                                </select>
                            </div>
                        </div>


                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Pincode</label>
                                <input class="form-control" type="text" autocomplete="off" id="pincode" name="pincode" readonly>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Select Course</label>
                                <select class="form-control select2" id="course" multiple="multiple" name="course[]" style="width: 100%;" disabled>
                                    <!-- Options will be populated dynamically -->
                                </select>
                            </div>
                        </div>
                        
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Institute Image</label>
                                <input class="form-control" type="file" autocomplete="off" id="institute_img" name="institute_img" alt="Institute Image" accept="image/png, image/jpeg" disabled>
                            
                                    <div id="currentInstituteImage" style="margin-top:10px;">
            <img id="instituteImagePreview" src="" alt="Institute Image" style="max-height: 100px; border: 1px solid rgb(221, 221, 221); padding: 5px;">
        </div>
                            </div>
                        </div>                        

                        <div class="col-md-4">
                            <div class="form-group">
                                <div class="radio">
                                    <input name="block_institute" value="0" type="radio" id="Option_1" class="with-gap radio-col-red" disabled>
                                    <label for="Option_1">Active</label>
                                </div>
                                <div class="radio">
                                    <input name="block_institute" value="1" type="radio" id="Option_2" class="with-gap radio-col-red" disabled>
                                    <label for="Option_2">Inactive</label>
                                </div>
                            </div>
                        </div>

                    </div>

                    <hr>
                    <div class="box-header-title">
                        <p class="box-title">Contact Person Details</p>
                        <div class="col-md-4 response-msg" id="responseMessage">
                        </div>
                    </div>

                    <!-- Contact Section (initial static row, if any, will be cleared/populated) -->
                    <div class="row contact-group">
                    </div>

                    <div id="additionalContactPersons"></div>


                    <div class="box-footer">
                        <a href="institute_master.php" class="btn btn-secondary"> Back</a>
                    </div>
                </div>
            </form>
        </div>
    </section>
</div>


<?php require_once('includes/footer.php'); ?>

<script>

$(document).ready(function() {
    
        // Event delegation for removing input fields
        $(document).on('click', '.removeButton', function() {
            $(this).closest('.contact-group').remove();
        });

        
            const urlParams = new URLSearchParams(window.location.search);
    const employeeId = urlParams.get('id');


    if (employeeId) {
        prepopulateInstituteForm(employeeId);
    }
    
    });
</script>

</body>
</html>