<?php
$page_name = 'View Question';

require_once('includes/connection.php');
require_once('includes/header.php');
?>

<div class="content-wrapper">
    <section class="content-header">
        <span class="p-10">
            VIEW QUESTION
        </span>
        <ol class="breadcrumb">
            <li><a href="masters.php"> Masters</a></li>
            <li><a href="question_master.php">Questions</a></li>
            <li class="active">View Question</li>
        </ol>
    </section>


    <section class="content">
        <div class="box box-default">
            <div class="box-header with-border">
                <p class="box-title">(Once the video is uploaded, it may take a few moments to appear.)</p>
                <div class="col-md-4 response-msg" id="responseMessage">
                </div>
            </div>

            <form id="questionForm" enctype="multipart/form-data">
                <div class="box-body">
                    <div class="row">
                        

                      <div class="col-md-4">
                        <div class="form-group">
                          <label>Category</label>
                          <select class="form-control select2" id="category" name="category" disabled></select>
                        </div>
                      </div>

                      <div class="col-md-4">
                        <div class="form-group">
                          <label>Level</label>
                          <select class="form-control select2" id="level" name="level" disabled>
                            <option value="">Select Level</option>
                            <option value="1">Easy</option>
                            <option value="2">Intermediate</option>
                            <option value="3">Hard</option>
                          </select>
                        </div>
                      </div>
 
                      <div class="col-md-4">
                        <div class="form-group">
                          <label>Question Criteria</label>
                          <select class="form-control select2" id="criteria" name="criteria" disabled>
                          <option value="quiz">For Quiz</option>
                          <option value="assignment">For Assignment</option>                          
                          </select>
                        </div>
                      </div>         
      
                    

                    </div>
                    
                    

                    <hr>
                    <div class="row">
                      <div class="col-md-4">
                        <div class="form-group">
                          <label>Media</label>
                          <select class="form-control select2" id="media_select" name="media_select" disabled>
                            <option value="Text">Text</option>
                            <option value="Image">Image</option>
                            <option value="Video">Video</option>
                          </select>
                        </div>
                      </div>
                        </div> 
                        

                    <div class="row">
                      <div class="col-md-4">
        <div class="form-group">
          <label>Question</label>
          <textarea class="form-control" id="question" name="question" rows="3" readonly></textarea>
        </div>
                      </div>

      <div class="col-md-4">
        <div class="form-group">
          <label>Marks</label>
          <input type="number" class="form-control" id="marks" name="marks" readonly>
        </div>
      </div>   
      
      <div class="col-md-4">
        <div class="form-group">
          <label>Duration (In Seconds)</label>
          <input type="number" class="form-control" id="duration" name="duration" readonly>
        </div>
      </div>       
      

      <div id="image_section" class="col-md-4">
        <div class="form-group">
          <label>Image Upload</label>
          <input type="file" class="form-control" id="image_upload" name="image_upload" accept="image/png, image/gif, image/jpeg" disabled>
        <div id="currentInstituteImage" style="margin-top:10px;">
            <img id="image_preview" src="" alt="Question Image" style="max-height: 100px; border: 1px solid rgb(221, 221, 221); padding: 5px;">
        </div>          
        </div>
      </div>      
      
      
<div class="col-md-4" id="video_section">
  <div class="form-group">
    <label>Youtube URL</label>
    <span class="float-right text-primary" id="switchToUpload" style="cursor: pointer;">Switch to video upload</span>
    <input type="text" class="form-control" id="video_url" name="video_url" readonly>
  </div>
</div>

<div class="col-md-4" id="video_section_upload" style="display: none;">
  <div class="form-group">
    <label>Video Upload</label>
    <span class="float-right text-primary" id="switchToUrl" style="cursor: pointer;">Switch to video URL</span>
    <input type="file" class="form-control" id="video_upload" name="video_upload" accept="video/mp4, video/*" readonly>
    
    <input type="text" class="form-control" id="video_title" name="video_title" placeholder="Video Title" style="margin-top: 5px;margin-bottom: 5px;" readonly>
    <div class="d-flex justify-content-center mt-3" style="    background: #151515;    border-radius: 6px;">
      <iframe 
        id="video_preview"
        width="100%"
        height="100"
        style="display: none; border-radius: 6px;"
        frameborder="0"
        allow="autoplay; fullscreen; picture-in-picture"
        allowfullscreen>
      </iframe>
    </div>
    
  </div>
</div>

<input type="hidden" id="video_mode" name="video_mode">

                      
                        </div> 
                        
                    
                    <hr>
                    <div class="row">
                      <div class="col-md-4">
                        <div class="form-group">
                          <label>Type</label>
                          <select class="form-control select2" id="type" name="type" disabled>
                            <option value="">Select Type</option>
                            <option value="yes_no">Yes / No</option>
                            <option value="true_false">True / False</option>
                            <option value="one_answer">One Right Answer</option>
                            <option value="multiple_answers">Multiple Right Answers</option>
                          </select>
                        </div>
                      </div>
                        </div>
                        

                    <div class="row" id="option_inputs">
                        
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Option 1</label>
                                <input class="form-control" type="text" autocomplete="off" id="option_1" name="option_1" readonly>
                            </div>
                        </div>
                        
                                                <div class="col-md-3">
                            <div class="form-group">
                                <label>Option 2</label>
                                <input class="form-control" type="text" autocomplete="off" id="option_2" name="option_2" readonly>
                            </div>
                        </div>
                        
                                                <div class="col-md-3">
                            <div class="form-group">
                                <label>Option 3</label>
                                <input class="form-control" type="text" autocomplete="off" id="option_3" name="option_3" readonly>
                            </div>
                        </div>
                        
                                                <div class="col-md-3">
                            <div class="form-group">
                                <label>Option 4</label>
                                <input class="form-control" type="text" autocomplete="off" id="option_4" name="option_4" readonly>
                            </div>
                        </div>

                        </div>   
                        

<div class="row" id="yes_no_radio">
                        
<div class="col-md-3">
    <div class="form-group">
<div class="radio">
  <input name="yes_no" value="yes" type="radio" id="yes_no_1" class="with-gap radio-col-red" disabled>
  <label for="yes_no_1">Yes</label>
</div>
<div class="radio">
  <input name="yes_no" value="no" type="radio" id="yes_no_0" class="with-gap radio-col-red" disabled>
  <label for="yes_no_0">No</label>
</div>
    </div>
</div>

</div> 



                        

<div class="row" id="true_false_radio">
                        
<div class="col-md-3">
    <div class="form-group">
        <div class="radio">
            <input name="true_false" value="true" type="radio" id="true_false_1" class="with-gap radio-col-red" disabled>
            <label for="true_false_1">True</label>
        </div>
        <div class="radio">
            <input name="true_false" value="false" type="radio" id="true_false_0" class="with-gap radio-col-red" disabled>
            <label for="true_false_0">False</label>
        </div>
    </div>
</div>

                    

                        </div>
                        
                        
<div class="row" id="one_right_dropdown">
                        
                        <div class="col-md-3">
                        <div class="form-group">
                          <label>Correct Answer</label>
                          <select class="form-control select2" id="option" name="option" disabled>
                            <option value="">Select Answer</option>
                            <option value="option_1">Option 1</option>
                            <option value="option_2">Option 2</option>
                            <option value="option_3">Option 3</option>
                            <option value="option_4">Option 4</option>
                          </select>
                        </div>
                        </div>
                    

                        </div>
                        
                        
<div class="row" id="multiple_right_dropdown">
                        
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Multiple Correct Answers</label>
                                <select class="form-control select2" id="multiple_options" multiple="multiple" name="multiple_options[]" data-placeholder="Select Multiple Answers" style="width: 100%;" disabled>
                            <option value="option_1">Option 1</option>
                            <option value="option_2">Option 2</option>
                            <option value="option_3">Option 3</option>
                            <option value="option_4">Option 4</option> 
                                </select>
                            </div>
                        </div>
                    

                        </div>                        
                        
                        

                    <div class="box-footer">
                        <a href="question_master.php" class="btn btn-secondary"> Back</a>
                    </div>
                </div>
            </form>
        </div>
    </section>
</div>


<?php require_once('includes/footer.php'); ?>

<script>
$(document).ready(function() {

  // Image validation
  $('#image_upload').on('change', function () {
    const file = this.files[0];
    if (file && file.size > 1 * 1024 * 1024) {
      alert('Image size must be less than 1 MB');
      $(this).val('');
    }
  });

  // Video validation
  $('#video_upload').on('change', function () {
    const file = this.files[0];
    if (file && file.size > 10 * 1024 * 1024) {
      alert('Video size must be less than 10 MB');
      $(this).val('');
    }
  });

  // Handle form submission
  $('#questionForm').on('submit', function(event) {
    event.preventDefault();

    const submitBtn = $('#submitBtn');
    submitBtn.prop('disabled', true).text('Submitting...');

    const urlParams = new URLSearchParams(window.location.search);
    const questionId = urlParams.get('id');

    if (!questionId) {
      showAlert('No question ID found in the URL!', 'danger');
      return;
    }

    // Use FormData for file + input fields
    var formData = new FormData();

    formData.append('category', $('#category').val());
    formData.append('level', $('#level').val());
    formData.append('criteria', $('#criteria').val());

    formData.append('media_select', $('#media_select').val());
    formData.append('question', $('#question').val());
    formData.append('marks', $('#marks').val());
    formData.append('duration', $('#duration').val());
    formData.append('question_id', questionId);

    formData.append('video_mode', $('#video_mode').val());

    const imageFile = $('#image_upload')[0]?.files[0];
    if (imageFile) formData.append('image_upload', imageFile);

    const videoFile = $('#video_upload')[0]?.files[0];
    if (videoFile) formData.append('video_upload', videoFile);

    formData.append('video_url', $('#video_url').val());
    formData.append('video_title', $('#video_title').val());

    // Question type and options
    const type = $('#type').val();
    formData.append('type', type);

    formData.append('option_1', $('#option_1').val());
    formData.append('option_2', $('#option_2').val());
    formData.append('option_3', $('#option_3').val());
    formData.append('option_4', $('#option_4').val());

    // ✅ Append correct answer(s) depending on type
    if (type === 'one_answer') {
      formData.append('correct_answer', $('#option').val());
    }

    if (type === 'multiple_answers') {
      ($('#multiple_options').val() || []).forEach(val => {
        formData.append('correct_answers[]', val);
      });
    }

    if (type === 'yes_no') {
      const yesNo = $('input[name="yes_no"]:checked').val();
      if (yesNo !== undefined) {
        formData.append('correct_answer', yesNo);
      }
    }

    if (type === 'true_false') {
      const trueFalse = $('input[name="true_false"]:checked').val();
      if (trueFalse !== undefined) {
        formData.append('correct_answer', trueFalse);
      }
    }

    // Send via AJAX
    $.ajax({
      url: 'apis/edit_question_api.php',
      method: 'POST',
      data: formData,
      contentType: false,   // Required for FormData
      processData: false,   // Required for FormData
      success: function(data) {
        if (data.status === 'success') {
          showAlert(data.message, 'success');
          $('#country').val(null).trigger('change');
        } else {
          showAlert(data.message, 'danger');
        }
      },
      error: function(xhr, status, error) {
        console.error('Error:', error);
        showAlert('An error occurred while processing your request.', 'danger');
        submitBtn.prop('disabled', false).text('Submit');
      },
      complete: function() {
        submitBtn.prop('disabled', false).text('Submit');
      }
    });
  });

  // Toggle media sections
  function toggleMediaSections() {
    const selected = $('#media_select').val();
    $('#video_section, #video_section_upload, #image_section').hide();

    if (selected === 'Image') {
      $('#image_section').show();
    } else if (selected === 'Video') {
      $('#video_section').show();
      $('#video_section_upload').hide();
      $('#video_mode').val('Youtube');
    }
  }

  toggleMediaSections();
  $('#media_select').on('change', toggleMediaSections);

  $('#switchToUpload').on('click', function () {
    $('#video_section').hide();
    $('#video_section_upload').show();
    $('#video_mode').val('vimeo');
  });

  $('#switchToUrl').on('click', function () {
    $('#video_section_upload').hide();
    $('#video_section').show();
    $('#video_mode').val('Youtube');
    $('#video_url').val('');
  });

  // Toggle question type fields
  function updateTypeFields() {
    const selectedType = $('#type').val();
    $('#option_inputs, #yes_no_radio, #true_false_radio, #one_right_dropdown, #multiple_right_dropdown').hide();

    if (selectedType === 'yes_no') {
      $('#yes_no_radio').show();
    } else if (selectedType === 'true_false') {
      $('#true_false_radio').show();
    } else if (selectedType === 'one_answer') {
      $('#option_inputs').show();
      $('#one_right_dropdown').show();
    } else if (selectedType === 'multiple_answers') {
      $('#option_inputs').show();
      $('#multiple_right_dropdown').show();
    }
  }

  updateTypeFields();
  $('#type').on('change', updateTypeFields);

  // Toggle marks/duration fields
  function toggleMarksField() {
    const selected = $('#criteria').val();
    if (selected === 'quiz') {
      $('#marks').closest('.col-md-4').hide().find('#marks').prop('required', false);
      $('#duration').closest('.col-md-4').hide().find('#duration').prop('required', false);
    } else if (selected === 'assignment') {
      $('#marks').closest('.col-md-4').show().find('#marks').prop('required', true);
      $('#duration').closest('.col-md-4').show().find('#duration').prop('required', true);
    }
  }

  toggleMarksField();
  $('#criteria').on('change', toggleMarksField);

  // Prepopulate if editing
  const urlParams = new URLSearchParams(window.location.search);
  const employeeId = urlParams.get('id');
  if (employeeId) {
    prepopulateQuestionForm(employeeId);
  }
});
</script>

</body>
</html>