<?php
$page_name = 'View Quiz';
require_once('includes/connection.php');
require_once('includes/header.php');
?>

<style>
input.question-checkbox.red:checked {
  accent-color: red; /* Modern way */
}
</style>

<div class="content-wrapper">
  <section class="content-header">
    <span class="p-10">VIEW QUIZ</span>
    <ol class="breadcrumb">
      <li><a href="masters.php">Masters</a></li>
      <li><a href="quiz_master.php">Quiz</a></li>
      <li class="active">View Quiz</li>
    </ol>
  </section>
  <section class="content">
    <div class="box box-default">
      <div class="box-header with-border">
        <p class="box-title">* Fields marked with an asterisk are required.</p>
        <div class="col-md-4 response-msg" id="responseMessage"></div>
      </div>
      <form id="quizForm" enctype="multipart/form-data">
        <div class="box-body">
          <div class="row">
            
            <div class="col-md-4">
              <div class="form-group">
                <label for="quizTitle">Quiz Title</label>
                <input type="text" id="quizTitle" name="quizTitle" class="form-control" readonly />
              </div>
            </div>

          </div>
        </div>
        <div class="box-body table-padding">
          <table id="dataGrid" class="table display">
            <thead style="background: #FAF7FE;">
              <tr>
                <th><input type="checkbox" id="select-all" class="question-checkbox red" style="margin-top: -15px;" disabled /></th>
                <th>Question</th>
                <th>Category</th>
                <th>Media</th>
              </tr>
            </thead>
          </table>
        </div>
        <div class="box-footer">
          <input type="hidden" name="selected_questions" id="selected_questions" />
          <a href="quiz_master.php" class="btn btn-secondary">Back</a>
        </div>
      </form>
    </div>
  </section>
</div>
<?php require_once('includes/footer.php'); ?>
<script>
let dataTable;
let selectedQuestions = new Set();

$(document).ready(function () {

  dataTable = $('#dataGrid').DataTable({
    processing: true,
    serverSide: true,
    ordering: false,
    autoWidth: false,
    language: { search: "Search:" },
    ajax: {
      url: 'apis/quiz_question_api.php',   // your updated API
      type: 'POST',
      data: function (d) {
        d.category_id = $('#category').val();
        d.selected_ids = Array.from(selectedQuestions).join(',');  // 👈 send only selected ids
      },
      beforeSend: function () {
        $('#page-loader').show();
      },
      complete: function () {
        $('#page-loader').hide();
      }
    },
    columns: [
      {
        data: 'question_master_id',
        orderable: false,
        render: function (data) {
          const checked = selectedQuestions.has(data.toString()) ? 'checked' : '';
          return `<input type="checkbox" class="question-checkbox red" value="${data}" ${checked} disabled>`;
        }
      },
      { data: 'question' },
      { data: 'category_name' },
      { data: 'media' }
    ],
    initComplete: function () {
      $('#dataGrid_filter input[type=search]').addClass('responsive-input');
    }
  });

  $('#category').on('change', function () {
    dataTable.ajax.reload();
  });

  // Restore checkbox states on table redraw
  $('#dataGrid').on('draw.dt', function () {
    $('#dataGrid .question-checkbox').each(function () {
      const id = this.value;
      this.checked = selectedQuestions.has(id);
    });
  });

  // Parse quizId from URL
  const urlParams = new URLSearchParams(window.location.search);
  const quizId = urlParams.get('id');

  if (quizId) {
    prepopulateQuizForm(quizId);
  }
});
</script>


</body>
</html>