<?php 
$page_name = 'Courses';
require_once('includes/connection.php');
require_once('includes/header_user.php');
?>

<style>
.content-wrapper, .main-footer {
    margin-left: unset !important;
}
.main-header .navbar {
    margin-left: unset !important;    
}
.skin-blue .main-header .navbar {
    border-bottom: 1px solid #5C2C8B;
}

/* Course Card */
.course-card {
  display: flex;
  justify-content: space-between;
  align-items: center;
  background-color: #fbf9ff;
  border: 2px solid #e6e1f5;
  border-radius: 12px;
  padding: 15px 20px;
  width: auto;
  font-family: Arial, sans-serif;
  margin-bottom: 20px;
  transition: 0.3s;
  cursor: pointer;
}
.course-info {
  display: flex;
  flex-direction: column;
}
.course-title {
  font-size: 16px;
  font-weight: 600;
  color: #3b1e84;
  margin-bottom: 5px;
  white-space: nowrap;
  overflow: hidden;
  text-overflow: ellipsis;
}
.course-date {
  font-weight: bold;
  color: #f44336;
  font-size: 14px;
  display: contents;
}
.course-arrow {
  background-color: #f44336;
  color: #fff;
  border-radius: 50%;
  width: 28px;
  height: 28px;
  display: flex;
  align-items: center;
  justify-content: center;
  font-size: 16px;
  transition: background-color 0.3s ease;
}
.course-arrow:hover {
  background-color: #d32f2f;
}

/* Lists */
.course-list {
  list-style: none;
  padding-left: 15px;
  padding-right: 15px;
}
.course-item {
  margin-bottom: 30px;
}
.course-item i {
  margin-right: 10px;
}
.course-details {
  font-size: 14px;
  color: #f44336;
  margin-left: 30px;
}
.course-details a {
  color: #f44336;
  text-decoration: none;
  font-weight: 500;
  margin-left: 6px;
}
.course-details a:hover {
  text-decoration: underline;
}

/* Deadline Box */
.deadline-container {
  display: flex;
  align-items: center;
  gap: 2rem;
  flex-wrap: wrap;
}
.deadline-text h3 {
  font-size: clamp(16px, 2vw, 20px);
  font-weight: bold;
  color: #5b2a86;
  margin: 0 0 0.5rem 0;
}
.deadline-text p {
  font-size: clamp(13px, 1.5vw, 16px);
  color: #ff6b5c;
  margin: 0;
}
.deadline-chart {
  position: relative;
  width: clamp(100px, 20vw, 150px);
  height: clamp(100px, 20vw, 150px);
  border-radius: 50%;
  background: conic-gradient(
    #ff6b5c 0deg 270deg,
    #5b2a86 270deg 360deg
  );
  display: flex;
  justify-content: center;
  align-items: center;
}
.deadline-chart::before {
  content: "";
  position: absolute;
  width: 65%;
  height: 65%;
  background: #fff;
  border-radius: 50%;
}
.deadline-chart span {
  position: absolute;
  font-size: clamp(14px, 2vw, 18px);
  font-weight: bold;
  color: #333;
  text-align: center;
}
.box-card-dash {
  background-color: #fbf9ff;
  border: 2px solid #e6e1f5;
  border-radius: 12px;
  padding: 15px 20px;
  font-family: Arial, sans-serif;
  margin-top:20px;
}

/* Category Box */
.category-title {
  font-size: 16px;
  font-weight: 600;
  color: #3b1e84;
  margin-top: 0;
}
.category-box {
  cursor: pointer;
  padding: 20px;
  border-radius: 10px;
  box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
  margin-bottom: 20px;
  background-color: #f7f7f7;
  transition: background-color 0.3s ease;
}
.category-box:hover {
  background-color: #ddd;
}

.content {
  padding: 20px 50px;
}
</style>


<section class="content">
    
    <!--<h3 style="font-weight: 600; color: #3b1e84;">Hello <?php echo $_SESSION['user_name'];?></h3>-->
    <!--<p>Welcome to EPiC learning management system !</p>-->
        
  
    <h3 style="font-weight: 600; color: #3b1e84;margin-bottom:20px;">EPIC Certificates</h3>    
    <div class="row">
        <ul class="course-list"></ul>
    </div>    

</section>

<?php require_once('includes/footer.php'); ?>

<script>


// --- API #3: Completed Courses ---
$.ajax({
    url: 'apis/fetch_completed_course.php',
    type: 'GET',
    dataType: 'json',
    success: function (response) {
        if (response.status === "success" && response.courses) {
            renderCompletedCourses(response.courses);
        } else {
            $(".course-list").html('<li>No completed courses available.</li>');
        }
    },
    error: function (xhr, status, error) {
        console.error("AJAX Error (completed courses):", status, error);
    }
});

// Render Completed Courses
function renderCompletedCourses(courses) {
    var listContainer = $(".course-list");
    listContainer.empty();

    if(courses.length === 0) {
        listContainer.html('<li>No completed courses available.</li>');
        return;
    }

    courses.forEach(function(course) {
        let completedDate = course.completed_date ? new Date(course.completed_date) : null;
        let formattedDate = completedDate 
            ? completedDate.toLocaleString('default', { day: 'numeric', month: 'long', year: 'numeric' }) 
            : 'N/A';

        const encId = btoa(course.course_id.toString());

        var listItem = `
            <li class="course-item">
                <i class="fa fa-check-circle" style="color:green;"></i>
                <span style="color: #3b1e84;font-weight: 600;">${course.course_title}</span>
                <div class="course-details">
                    Completed on: ${formattedDate}
                    <a href="certificate.php?course=${course.course_id}&download=pdf">| Download Certificate</a>
                </div>
            </li>
        `;
        listContainer.append(listItem);
    });
}

</script>

</body>
</html>