<?php
require_once('../includes/connection.php');
header('Content-Type: application/json');

$user_id = $_SESSION['user_id'] ?? 0;
$institute_id = $_SESSION['institute_id'] ?? 0;
$course_id = $_POST['course_id'] ?? 0;
$last_content_index = $_POST['last_content_index'] ?? 0;
$max_completed_index = $_POST['max_completed_index'] ?? 0;

if (!$user_id || !$course_id) {
  echo json_encode(['status' => 'error', 'message' => 'Missing data']);
  exit;
}

try {
$stmt = $pdo->prepare("
  INSERT INTO user_course_progress (user_id, course_id, institute_id, last_content_index, max_completed_index)
  VALUES (:user_id, :course_id, :institute_id, :last_content_index, :max_completed_index)
  ON DUPLICATE KEY UPDATE
    last_content_index = :last_content_index_upd,
    max_completed_index = :max_completed_index_upd,
    updated_at = NOW()
");
$stmt->execute([
  ':user_id' => $user_id,
  ':course_id' => $course_id,
  ':institute_id' => $institute_id,
  ':last_content_index' => $last_content_index,
  ':max_completed_index' => $max_completed_index,
  ':last_content_index_upd' => $last_content_index,
  ':max_completed_index_upd' => $max_completed_index
]);

  echo json_encode(['status' => 'success']);
} catch (PDOException $e) {
  echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
?>
